unit SSUCfg;
interface
uses
 SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
 Forms, Dialogs, StdCtrls, Buttons, Spin, ComCtrls, ExtCtrls;
type
 TConfigForm=class(TForm)
  OkBtn:TButton;
  CancelBtn:TButton;
  TestBtn:TButton;
  SpeedGroupBox:TGroupBox;
  SpeedTrackBar:TTrackBar;
  LowSpeedLabel:TLabel;
  HiSpeedLabel:TLabel;
  SnowGroupBox:TGroupBox;
  SnowLabel:TLabel;
  SnowSpinEdit:TSpinEdit;
  SnowLineLabel:TLabel;
  SnowLineSpinEdit:TSpinEdit;
  MoveGroupBox:TGroupBox;
  DXLabel:TLabel;
  DXSpinEdit:TSpinEdit;
  PictureGroupBox:TGroupBox;
  PathLabel:TLabel;
  PathEdit:TEdit;
  ButtonPanel:TPanel;
  BrowseSpeedButton:TSpeedButton;
  ConfigOpenDialog:TOpenDialog;
  BegStatGroupBox:TGroupBox;
  BBlackScrRadioButton:TRadioButton;
  BPictureRadioButton:TRadioButton;
  BCurScrRadioButton:TRadioButton;
  EndStatGroupBox:TGroupBox;
  EPictureRadioButton:TRadioButton;
  EBlackScrRadioButton:TRadioButton;
  ECurScrRadioButton:TRadioButton;
  procedure FormCreate(Sender:TObject);
  procedure OkBtnClick(Sender:TObject);
  procedure CancelBtnClick(Sender:TObject);
  procedure TestBtnClick(Sender:TObject);
  procedure BrowseSpeedButtonClick(Sender:TObject);
 private
  procedure LoadConfig;
  procedure SaveConfig;
 public
 end;
var
 ConfigForm:TConfigForm;

implementation
{$R *.DFM}
uses
 SSUMain, IniFiles;
type
 String30=string[30];
const
 IniFileName='Snow.ini';
 Sections:array[1..1] of String30=('Config');
 Idents1:array[1..7] of String30=
 ('Snow','SnowLine','DX','Speed','Picture',
  'BeginStat','EndStat');
var
 IniFile:TIniFile;

procedure TConfigForm.LoadConfig;
var
 i:Integer;
begin
 IniFile:=TIniFile.Create(IniFileName);
 with IniFile do
  try
   SnowSpinEdit.Value:=ReadInteger(Sections[1],Idents1[1],SnowSpinEdit.Value);
   SnowLineSpinEdit.Value:=ReadInteger(Sections[1],Idents1[2],SnowLineSpinEdit.Value);
   DXSpinEdit.Value:=ReadInteger(Sections[1],Idents1[3],DXSpinEdit.Value);
   i:=ReadInteger(Sections[1],Idents1[4],SpeedTrackBar.Position);
   if (i>=SpeedTrackBar.Min) and (i<=SpeedTrackBar.Max) then
    SpeedTrackBar.Position:=i;
   PathEdit.Text:=ReadString(Sections[1],Idents1[5],'');
   i:=ReadInteger(Sections[1],Idents1[6],1);
   case i of
    1: BBlackScrRadioButton.Checked:=True;
    2: BPictureRadioButton.Checked:=True;
    3: BCurScrRadioButton.Checked:=True;
   end;
   i:=ReadInteger(Sections[1],Idents1[7],1);
   case i of
    1: EBlackScrRadioButton.Checked:=True;
    2: EPictureRadioButton.Checked:=True;
    3: ECurScrRadioButton.Checked:=True;
   end;
  finally
   Free;
  end;
end;

procedure TConfigForm.SaveConfig;
var
 i:Integer;
begin
 IniFile:=TIniFile.Create(IniFileName);
 with IniFile do
  try
   WriteInteger(Sections[1],Idents1[1],SnowSpinEdit.Value);
   WriteInteger(Sections[1],Idents1[2],SnowLineSpinEdit.Value);
   WriteInteger(Sections[1],Idents1[3],DXSpinEdit.Value);
   WriteInteger(Sections[1],Idents1[4],SpeedTrackBar.Position);
   WriteString(Sections[1],Idents1[5],PathEdit.Text);
   if BBlackScrRadioButton.Checked then i:=1
   else if BPictureRadioButton.Checked then i:=2
   else i:=3;
   WriteInteger(Sections[1],Idents1[6],i);
   if EBlackScrRadioButton.Checked then i:=1
   else if EPictureRadioButton.Checked then i:=2
   else i:=3;
   WriteInteger(Sections[1],Idents1[7],i);
  finally
   Free;
  end;
end;

procedure TConfigForm.FormCreate(Sender:TObject);
begin
 LoadConfig;
end;

procedure TConfigForm.OkBtnClick(Sender:TObject);
begin
 SaveConfig;
 Close;
end;

procedure TConfigForm.CancelBtnClick(Sender:TObject);
begin
 Close;
end;

procedure TConfigForm.TestBtnClick(Sender:TObject);
begin
 ScreenSaverForm.Show;
end;

procedure TConfigForm.BrowseSpeedButtonClick(Sender:TObject);
begin
 ConfigOpenDialog.FileName:=PathEdit.Text;
 if ConfigOpenDialog.Execute then
  PathEdit.Text:=ConfigOpenDialog.FileName;
end;

end.
