unit SSUMain;
interface
uses
 SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
 Forms, Dialogs, ExtCtrls;
type
 TScreenSaverForm=class(TForm)
  TickTimer:TTimer;
  PaintTimer:TTimer;
  procedure TickTimerTimer(Sender:TObject);
  procedure FormShow(Sender:TObject);
  procedure FormHide(Sender:TObject);
  procedure FormCreate(Sender:TObject);
  procedure PaintTimerTimer(Sender:TObject);
 private
  { Private declarations }
  procedure DeactivateScreenSaver(var Msg:TMsg;var Handled:Boolean);
 public
  { Public declarations }
 end;
 PointType=record
  x,y:Integer;
 end;
var
 ScreenSaverForm:TScreenSaverForm;
 BmpScr,BmpCurScr:TBitmap;
 Snow:array[1..2000] of PointType;
 MaxQSnow,
 QSnowLine,
 DxSnow:Integer;
 x,y:Integer;

implementation
{$R *.DFM}
uses SSUCfg;
var
 Crs:TPoint;  {     }

procedure TScreenSaverForm.DeactivateScreenSaver(var Msg:TMsg;var Handled:Boolean);
var
 Done:Boolean;
begin
 Done:=False;
 case Msg.Message of
  WM_ACTIVATE,
  WM_ACTIVATEAPP,
  WM_NCACTIVATE: Done:=Msg.wParam=0;
  WM_SETCURSOR: Cursor:=crNone;
  WM_LBUTTONDOWN,
  WM_RBUTTONDOWN,
  WM_MBUTTONDOWN,
  WM_KEYDOWN,
  WM_KEYUP: Done:=True;
  WM_MOUSEMOVE:
   Done:=(Abs(LOWORD(Msg.lParam)-Crs.x)>0) or
         (Abs(HIWORD(Msg.lParam)-Crs.y)>0);
  WM_DESTROY: Done:=True;
 end;
 if Done then
  begin
   Hide;
   Close;
  end;
end;

procedure TScreenSaverForm.TickTimerTimer(Sender:TObject);
var
 i,NSnow:Integer;
 p:LongInt;
begin
 NSnow:=0;
 Randomize;
 for i:=1 to MaxQSnow do
  if (Snow[i].x=0) and (Snow[i].y=0) then
   if NSnow<QSnowLine then
    begin
     while Snow[i].x=0 do Snow[i].x:=Random(ClientWidth);
     Snow[i].y:=Random(2*(QSnowLine*ClientHeight div MaxQSnow+1)+1);
     Inc(NSnow);
    end
   else
  else
   begin
    if ConfigForm.EBlackScrRadioButton.Checked then p:=0
    else if ConfigForm.EPictureRadioButton.Checked then
     p:=BmpScr.Canvas.Pixels[Snow[i].x-x,Snow[i].y-y]
    else p:=BmpCurScr.Canvas.Pixels[Snow[i].x,Snow[i].y];
    Canvas.Pixels[Snow[i].x,Snow[i].y]:=p;
    if Snow[i].x mod 2=1 then
     begin
      if ConfigForm.EBlackScrRadioButton.Checked then p:=0
      else if ConfigForm.EPictureRadioButton.Checked then
       p:=BmpScr.Canvas.Pixels[Snow[i].x-x+1,Snow[i].y-y]
      else p:=BmpCurScr.Canvas.Pixels[Snow[i].x+1,Snow[i].y];
      Canvas.Pixels[Snow[i].x+1,Snow[i].y]:=p;
     end;
    if Snow[i].y mod 2=1 then
     begin
      if ConfigForm.EBlackScrRadioButton.Checked then p:=0
      else if ConfigForm.EPictureRadioButton.Checked then
       p:=BmpScr.Canvas.Pixels[Snow[i].x-x,Snow[i].y-y+1]
      else p:=BmpCurScr.Canvas.Pixels[Snow[i].x,Snow[i].y+1];
      Canvas.Pixels[Snow[i].x,Snow[i].y+1]:=p;
     end;
    Snow[i].x:=Snow[i].x+Random(DxSnow*2+1)-DxSnow;
    Snow[i].y:=Snow[i].y+1+
     Random(2*(QSnowLine*ClientHeight div MaxQSnow+1)+1);
    if Snow[i].y>ClientHeight then
     begin
      Snow[i].x:=0;
      Snow[i].y:=0;
     end
    else
     begin
      Canvas.Pixels[Snow[i].x,Snow[i].y]:=clWhite;
      if Snow[i].x mod 2=1 then
       Canvas.Pixels[Snow[i].x+1,Snow[i].y]:=clWhite;
      if Snow[i].y mod 2=1 then
       Canvas.Pixels[Snow[i].x,Snow[i].y+1]:=clWhite
     end;
   end;
end;

procedure TScreenSaverForm.FormShow(Sender:TObject);
begin
 PaintTimer.Enabled:=True;
end;

procedure TScreenSaverForm.FormHide(Sender:TObject);
begin
 if PaintTimer.Enabled then Exit;
 WindowState:=wsNormal;
 Application.OnMessage:=nil;
 TickTimer.Enabled:=False;
 ShowCursor(True);
 if BmpScr<>nil then BmpScr.Free;
 if BmpCurScr<>nil then BmpCurScr.Free;
end;

procedure TScreenSaverForm.FormCreate(Sender:TObject);
begin
 Left:=0;
 Top:=0;
 Width:=0;
 Height:=0;
end;

procedure TScreenSaverForm.PaintTimerTimer(Sender:TObject);
var
 i:Integer;
 hdcScreen:HDC;
begin
 ShowWindow(Handle,SW_HIDE);
 hdcScreen:=CreateDC('DISPLAY',nil,nil,nil);
 BmpCurScr:=TBitmap.Create;
 BmpCurScr.Handle:=CreateCompatibleBitmap(hdcScreen,
              GetDeviceCaps(hdcScreen,HORZRES),
              GetDeviceCaps(hdcScreen,VERTRES));
 BitBlt(BmpCurScr.Canvas.Handle,
        0,0,BmpCurScr.Width,BmpCurScr.Height,
        hdcScreen,0,0,SRCCOPY);
 DeleteDC(hdcScreen);
 WindowState:=wsMaximized;
 Show;
 if ConfigForm.BCurScrRadioButton.Checked then Canvas.Draw(0,0,BmpCurScr);
 GetCursorPos(Crs);
 TickTimer.Interval:=1001-ConfigForm.SpeedTrackBar.Position*40;
 TickTimer.Enabled:=True;
 Application.OnMessage:=DeactivateScreenSaver;
 ShowCursor(False);
 MaxQSnow:=ConfigForm.SnowSpinEdit.Value;
 QSnowLine:=ConfigForm.SnowLineSpinEdit.Value;
 DXSnow:=ConfigForm.DXSpinEdit.Value;
 Randomize;
 BmpScr:=TBitmap.Create;
 try
  BmpScr.LoadFromFile(ConfigForm.PathEdit.Text);
 except
  on EFOpenError do;
  on EInvalidGraphic do;
 end;
 BmpScr.Canvas.Brush.Color:=clBlack;
 x:=(ClientWidth-BmpScr.Width) div 2;
 y:=(ClientHeight-BmpScr.Height) div 2;
 if ConfigForm.BPictureRadioButton.Checked then
  Canvas.Draw(x,y,BmpScr);
 for i:=1 to MaxQSnow do
  begin
   Snow[i].x:=Random(ClientWidth);
   Snow[i].y:=Random(ClientHeight);
  end;
 PaintTimer.Enabled:=False;
end;

end.
