unit SSUCfg;
interface
uses
 SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
 Forms, Dialogs, StdCtrls, Buttons, Spin, ComCtrls;
type
 TConfigForm=class(TForm)
  OkBtn:TButton;
  CancelBtn:TButton;
  TestBtn:TButton;
  SpeedGroupBox:TGroupBox;
  SpeedTrackBar:TTrackBar;
  LowSpeedLabel:TLabel;
  HiSpeedLabel:TLabel;
  SnowflakeGroupBox:TGroupBox;
  SnowflakeLabel:TLabel;
  SnowflakeSpinEdit:TSpinEdit;
  SizeLabel:TLabel;
  SizeSpinEdit:TSpinEdit;
  BackgroundGroupBox:TGroupBox;
  BlackScrRadioButton:TRadioButton;
  CurScrRadioButton:TRadioButton;
  procedure FormCreate(Sender:TObject);
  procedure OkBtnClick(Sender:TObject);
  procedure CancelBtnClick(Sender:TObject);
  procedure TestBtnClick(Sender:TObject);
 private
  procedure LoadConfig;
  procedure SaveConfig;
 public
 end;
var
 ConfigForm:TConfigForm;

implementation
{$R *.DFM}
uses
 SSUMain, IniFiles;
type
 String30=string[30];
const
 IniFileName='Snowflak.ini';
 Sections:array[1..1] of String30=('Config');
 Idents1:array[1..4] of String30=
 ('Snowflake','Size','Speed','Background');
var
 IniFile:TIniFile;

procedure TConfigForm.LoadConfig;
var
 i:Integer;
begin
 IniFile:=TIniFile.Create(IniFileName);
 with IniFile do
  try
   SnowflakeSpinEdit.Value:=ReadInteger(Sections[1],Idents1[1],50);
   SizeSpinEdit.Value:=ReadInteger(Sections[1],Idents1[2],100);
   i:=ReadInteger(Sections[1],Idents1[3],SpeedTrackBar.Max);
   if (i>=SpeedTrackBar.Min) and (i<=SpeedTrackbar.Max) then
    SpeedTrackBar.Position:=i
   else SpeedTrackBar.Position:=SpeedTrackBar.Max;
   i:=ReadInteger(Sections[1],Idents1[4],1);
   if i=1 then BlackScrRadioButton.Checked:=true
   else CurScrRadioButton.Checked:=true;
  finally
   Free;
  end;
end;

procedure TConfigForm.SaveConfig;
var
 i:Integer;
begin
 IniFile:=TIniFile.Create(IniFileName);
 with IniFile do
  try
   WriteInteger(Sections[1],Idents1[1],SnowflakeSpinEdit.Value);
   WriteInteger(Sections[1],Idents1[2],SizeSpinEdit.Value);
   WriteInteger(Sections[1],Idents1[3],SpeedTrackBar.Position);
   if BlackScrRadioButton.Checked then i:=1
   else i:=2;
   WriteInteger(Sections[1],Idents1[4],i);
  finally
   Free;
  end;
end;

procedure TConfigForm.FormCreate(Sender:TObject);
begin
 LoadConfig;
end;

procedure TConfigForm.OkBtnClick(Sender:TObject);
begin
 SaveConfig;
 Close;
end;

procedure TConfigForm.CancelBtnClick(Sender:TObject);
begin
 Close;
end;

procedure TConfigForm.TestBtnClick(Sender:TObject);
begin
 ScreenSaverForm.Show;
end;

end.
