unit SSUMain;
interface
uses
 SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
 Forms, Dialogs, ExtCtrls;
type
 TScreenSaverForm=class(TForm)
  TickTimer:TTimer;
  PaintTimer:TTimer;
  procedure TickTimerTimer(Sender:TObject);
  procedure FormShow(Sender:TObject);
  procedure FormHide(Sender:TObject);
  procedure PaintTimerTimer(Sender:TObject);
  procedure FormCreate(Sender:TObject);
 private
  { Private declarations }
  procedure DrawRayBySnowFlake
    (x0,y0,Ang1,Ang2,LenRay,QSubRay,FirstSubRay,NSubRay,
     ReductionLenSubRay,ReductionQSubRay,LenSmallRay:Integer;
     Progress:Real;ScatterAdd:Integer;Clr1,Clr2:TColor);
  procedure DrawSnowFlake
    (x0,y0,QRay,Ang1,Ang2,LenRay,QSubRay,FirstSubRay,NSubRay,
     ReductionLenSubRay,ReductionQSubRay,LenSmallRay:Integer;
     Progress:Real;ScatterAdd:Integer);
  procedure DeactivateScreenSaver(var Msg:TMsg;var Handled:Boolean);
 public
  { Public declarations }
 end;
var
 ScreenSaverForm:TScreenSaverForm;
 BmpCurScr:TBitmap;
 HideYes:Boolean;

implementation
{$R *.DFM}
uses SSUCfg;
var
 Crs:TPoint; {     }

function Rad(Grad:Integer):Real;
begin
 Result:=Grad*pi/180;
end;

procedure TScreenSaverForm.DrawRayBySnowFlake
      (x0,y0, {    }
       Ang1,  {    }
       Ang2,  {      }
       LenRay, {   }
       QSubRay, {   }
       FirstSubRay, {  ,    }
       NSubRay,     {    
                             }
       ReductionLenSubRay, {     
                                       ( ) }
       ReductionQSubRay, {      
                                         ( ) }
       LenSmallRay:Integer; {    }
       Progress:Real;  {   
                            (  ) }
       ScatterAdd:Integer; {     ( ) }
       Clr1, {   }
       Clr2:TColor); {   }
var
 x0N,y0N,Dist,i,QSubRayN,LenSubRay,SA:Integer;
begin
 Canvas.Pen.Color:=Clr1;
 Canvas.MoveTo(x0,y0);
 Canvas.LineTo(x0+Round(LenRay*Sin(Rad(Ang1))),
               y0+Round(LenRay*Cos(Rad(Ang1))));
 if QSubRay=0 then Exit;
 for i:=FirstSubRay to QSubRay-1 do
  begin
   Dist:=(LenRay*i) div QSubRay;
   SA:=Random(2*ScatterAdd+1)-ScatterAdd;
   if (Dist+SA>=0) and (Dist+SA<=LenRay) then Dist:=Dist+SA;
   x0N:=x0+Round(Dist*Sin(Rad(Ang1)));
   y0N:=y0+Round(Dist*Cos(Rad(Ang1)));
   if i mod (NSubRay+1)=0 then
    begin
     LenSubRay:=LenRay div Round(ReductionLenSubRay+i*Progress);
     QSubRayN:=QSubRay div ReductionQSubRay;
    end
   else
    begin
     LenSubRay:=LenSmallRay;
     QSubRayN:=0;
    end;
   DrawRayBySnowFlake(x0N,y0N,Ang1+Ang2,Ang2,LenSubRay,
                 QSubRayN,1,NSubRay,ReductionLenSubRay,
                 ReductionQSubRay,LenSmallRay,Progress,ScatterAdd,Clr2,Clr2);
   DrawRayBySnowFlake(x0N,y0N,Ang1-Ang2,Ang2,LenSubRay,
                 QSubRayN,1,NSubRay,ReductionLenSubRay,
                 ReductionQSubRay,LenSmallRay,Progress,ScatterAdd,Clr2,Clr2)
  end;
end;


procedure TScreenSaverForm.DrawSnowFlake
      (x0,y0,QRay,Ang1,Ang2,LenRay,QSubRay,FirstSubRay,NSubRay,
       ReductionLenSubRay,ReductionQSubRay,LenSmallRay:integer;
       Progress:real;ScatterAdd:integer);
var
 i:Integer;
 r,g,b:Byte;
begin
 for i:=1 to QRay do
  begin
   r:=$C0+Random($30);
   g:=r;
   b:=r+Random($100-r);
   DrawRayBySnowFlake(x0,y0,(360*i) div QRay+Ang1,Ang2,
      LenRay,QSubRay,FirstSubRay,NSubRay,
      ReductionLenSubRay,ReductionQSubRay,LenSmallRay,
      Progress,ScatterAdd,RGB(r,g,b),RGB(r,g,b));
   DrawRayBySnowFlake(x0,y0,(360*i) div QRay+Ang1+180 div QRay,Ang2,
      LenRay div 2,QSubRay,FirstSubRay,NSubRay,
      ReductionLenSubRay,ReductionQSubRay,LenSmallRay,
      Progress,ScatterAdd,RGB(r,g,b),RGB(r,g,b));
  end;
end;

procedure TScreenSaverForm.DeactivateScreenSaver(var Msg:TMsg;var Handled:Boolean);
var
 Done:Boolean;
begin
 Done:=False;
 case Msg.Message of
  WM_ACTIVATE,
  WM_ACTIVATEAPP,
  WM_NCACTIVATE: Done:=Msg.wParam=0;
  WM_SETCURSOR: Cursor:=crNone;
  WM_LBUTTONDOWN,
  WM_RBUTTONDOWN,
  WM_MBUTTONDOWN,
  WM_KEYDOWN,
  WM_KEYUP: Done:=True;
  WM_MOUSEMOVE:
   Done:=(Abs(LOWORD(Msg.lParam)-Crs.x)>5) or
         (Abs(HIWORD(Msg.lParam)-Crs.y)>5);
  WM_DESTROY: Done:=True;
 end;
 if Done then
  begin
   Hide;
   Close;
  end;
end;

procedure TScreenSaverForm.TickTimerTimer(Sender:TObject);
const
 SCount:Integer=0;
var
 x,y:Integer;
 Size:Integer;
 lsr:Integer;
begin
 if SCount>ConfigForm.SnowflakeSpinEdit.Value then
  begin
   if ConfigForm.BlackScrRadioButton.Checked then Refresh
   else Canvas.Draw(0,0,BmpCurScr);
   SCount:=0;
 end;
 Inc(SCount);
 x:=Random(ClientWidth); y:=Random(ClientHeight);
 Size:=ConfigForm.SizeSpinEdit.MinValue+
  Random(ConfigForm.SizeSpinEdit.Value+ConfigForm.SizeSpinEdit.MinValue-1);
 if Size<20 then lsr:=1 else
 if Size<50 then lsr:=3 else lsr:=5;
 DrawSnowFlake(x,y,6+Random(4),Random(90),
   30+Random(20),size,10+Random(size div 20),
   1+Random(3),2+Random(2),2+Random(3),2+Random(3),lsr,
   5/(5+Random(10)),2);
end;

procedure TScreenSaverForm.FormShow(Sender:TObject);
begin
 PaintTimer.Enabled:=True;
end;

procedure TScreenSaverForm.FormHide(Sender:TObject);
begin
 if PaintTimer.Enabled then Exit;
 WindowState:=wsNormal;
 Application.OnMessage:=nil;
 TickTimer.Enabled:=False;
 ShowCursor(True);
 if BmpCurScr<>nil then BmpCurScr.Free;
end;

procedure TScreenSaverForm.PaintTimerTimer(Sender:TObject);
var
 hdcScreen:HDC;
begin
 ShowWindow(Handle,SW_HIDE);
 hdcScreen:=CreateDC('DISPLAY',nil,nil,nil);
 BmpCurScr:=TBitmap.Create;
 BmpCurScr.Handle:=CreateCompatibleBitmap(hdcScreen,
              GetDeviceCaps(hdcScreen,HORZRES),
              GetDeviceCaps(hdcScreen,VERTRES));
 BitBlt(BmpCurScr.Canvas.Handle,
        0,0,BmpCurScr.Width,BmpCurScr.Height,
        hdcScreen,0,0,SRCCOPY);
 DeleteDC(hdcScreen);
 WindowState:=wsMaximized;
 Show;
 if ConfigForm.CurScrRadioButton.Checked then Canvas.Draw(0,0,BmpCurScr);
 GetCursorPos(Crs);
 TickTimer.Interval:=1001-ConfigForm.SpeedTrackBar.Position*40;
 TickTimer.Enabled:=True;
 Application.OnMessage:=DeactivateScreenSaver;
 ShowCursor(False);
 PaintTimer.Enabled:=False;
end;

procedure TScreenSaverForm.FormCreate(Sender:TObject);
begin
 Left:=0;
 Top:=0;
 Width:=0;
 Height:=0;
end;

end.
