unit doceditu;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ComCtrls, StdCtrls, DB, DBTables;

type
  TDocEditForm = class(TForm)
    DocNumberLabel: TLabel;
    DocNumberEdit: TEdit;
    DocDateLabel: TLabel;
    DocDateEdit: TEdit;
    IdDocLabel: TLabel;
    IdDocEdit: TEdit;
    RegNumberLabel: TLabel;
    RegNumberEdit: TEdit;
    RegDateLabel: TLabel;
    RegDateEdit: TEdit;
    DocCreatorLabel: TLabel;
    DocCreatorEdit: TEdit;
    DocNoteLabel: TLabel;
    DocNoteMemo: TMemo;
    DocPageControl: TPageControl;
    EntrustTabSheet: TTabSheet;
    CheckTabSheet: TTabSheet;
    RemoveCheckTabSheet: TTabSheet;
    LineStringGrid: TStringGrid;
    CheckStringGrid: TStringGrid;
    RemCheckStringGrid: TStringGrid;
    SaveButton: TButton;
    OKButton: TButton;
    CancelButton: TButton;
    WorkQuery: TQuery;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    function SaveRecord:integer;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DocEditForm: TDocEditForm;
  filepath:string;
  NewRec:boolean;
  SaveFlag:boolean;
  EditIdDoc:integer;
  pc:array[1..2048] of char;
  fok:boolean;

implementation

{$R *.dfm}

procedure TDocEditForm.FormCreate(Sender: TObject);
var
 ppi:real;
 i:integer;
begin
 ppi:=PixelsPerInch/96;
 with LineStringGrid do
  begin
   ColWidths[0]:=Round(30*ppi);
   ColWidths[1]:=Round(120*ppi);
   ColWidths[2]:=Round(150*ppi);
   ColWidths[3]:=Round(70*ppi);
   ColWidths[4]:=Round(70*ppi);
   ColWidths[5]:=Round(120*ppi);
   ColWidths[6]:=Round(70*ppi);
   Cells[0,0]:=' ';
   Cells[1,0]:='';
   Cells[2,0]:=' ';
   Cells[3,0]:='';
   Cells[4,0]:=' .';
   Cells[5,0]:='';
   Cells[6,0]:='';
   for i:=1 to 11 do
    if i<10 then Cells[0,i]:='  '+IntToStr(i)
    else Cells[0,i]:=' '+IntToStr(i);
  end;
 with CheckStringGrid do
  begin
   ColWidths[0]:=Round(30*ppi);
   ColWidths[1]:=Round(534*ppi);
   ColWidths[2]:=Round(70*ppi);
   Cells[0,0]:=' ';
   Cells[1,0]:=' ';
   Cells[2,0]:='';
   for i:=1 to 11 do
    if i<10 then Cells[0,i]:='  '+IntToStr(i)
    else Cells[0,i]:=' '+IntToStr(i);
  end;
 with RemCheckStringGrid do
  begin
   ColWidths[0]:=Round(30*ppi);
   ColWidths[1]:=Round(534*ppi);
   ColWidths[2]:=Round(70*ppi);
   Cells[0,0]:=' ';
   Cells[1,0]:='    ';
   Cells[2,0]:='';
   for i:=1 to 11 do
    if i<10 then Cells[0,i]:='  '+IntToStr(i)
    else Cells[0,i]:=' '+IntToStr(i);
  end;
end;

procedure TDocEditForm.FormActivate(Sender: TObject);
var i,j:integer;
 bs:TBlobStream;
begin
 fok:=false;
 DocPageControl.ActivePageIndex:=0;
 LineStringGrid.Col:=1;
 LineStringGrid.Row:=1;
 CheckStringGrid.Col:=1;
 CheckStringGrid.Row:=1;
 RemCheckStringGrid.Col:=1;
 RemCheckStringGrid.Row:=1;
 DocNumberEdit.SetFocus;
 with LineStringGrid do
  for i:=1 to ColCount do
   for j:=1 to RowCount do
    Cells[i,j]:='';
 with CheckStringGrid do
  for i:=1 to ColCount do
   for j:=1 to RowCount do
    Cells[i,j]:='';
 with RemCheckStringGrid do
  for i:=1 to ColCount do
   for j:=1 to RowCount do
    Cells[i,j]:='';
 if NewRec then
  begin
   Caption:=' ';
   SaveFlag:=false;
   DocNumberEdit.Text:='';
   DocDateEdit.Text:='';
   IdDocEdit.Text:='';
   DocCreatorEdit.Text:='';
   RegNumberEdit.Text:='';
   RegDateEdit.Text:='';
   DocNoteMemo.Lines.Clear;
  end
 else
  begin
   Caption:=' ';
   SaveFlag:=true;
   with WorkQuery do
    begin
     SQL.Clear;
     SQL.Add('SELECT IDDOC, DOCNUMBER, DOCDATE, DOCCREATOR, REGNUMBER, REGDATE, DOCNOTE FROM "'+filepath+'\docum.db" WHERE IDDOC='+IntToStr(EditIdDoc));
     Open;
     IdDocEdit.Text:=Fields[0].AsString;
     DocNumberEdit.Text:=Fields[1].AsString;
     DocDateEdit.Text:=Fields[2].AsString;
     DocCreatorEdit.Text:=Fields[3].AsString;
     RegNumberEdit.Text:=Fields[4].AsString;
     RegDateEdit.Text:=Fields[5].AsString;
     bs:=nil;
     try
      bs:=TBlobStream.Create(Fields[6] as TBlobField, bmRead);
      bs.Read(pc,bs.Size);
      j:=bs.Size;
     except;
      j:=0;
     end;
     if bs<>nil then bs.Free;
     DocNoteMemo.Text:=Copy(pc,1,j);
     Close;
     SQL.Clear;
     SQL.Add('SELECT IDDOCLINE, IDDOC, TOPERSON, ENTRUST, ENTRUSTDATE, PDATE, PPERSON, PRDATE FROM "'+
      filepath+'\docline.db" WHERE IDDOC='+IntToStr(EditIdDoc)+' ORDER BY IDDOCLINE');
     Open;
     i:=1;
     while not EOF do
      begin
       with LineStringGrid do
        begin
         Cells[1,i]:=Fields[2].AsString;
         bs:=nil;
         try
          bs:=TBlobStream.Create(Fields[3] as TBlobField, bmRead);
          bs.Read(pc,bs.Size);
          j:=bs.Size;
         except;
          j:=0;
         end;
         if bs<>nil then bs.Free;
         Cells[2,i]:=Copy(pc,1,j);
         Cells[3,i]:=Fields[4].AsString;
         Cells[4,i]:=Fields[5].AsString;
         Cells[5,i]:=Fields[6].AsString;
         Cells[6,i]:=Fields[7].AsString;
        end;
       Inc(i);
       Next;
       if i>11 then break;
      end;
     Close;
     SQL.Clear;
     SQL.Add('SELECT IDCHECK, IDDOC, DESCRIPTION, CHECKDATE FROM "'+
      filepath+'\check.db" WHERE IDDOC='+IntToStr(EditIdDoc)+' ORDER BY IDCHECK');
     Open;
     i:=1;
     while not EOF do
      begin
       with CheckStringGrid do
        begin
         bs:=nil;
         try
          bs:=TBlobStream.Create(Fields[2] as TBlobField, bmRead);
          bs.Read(pc,bs.Size);
          j:=bs.Size;
         except;
          j:=0;
         end;
         if bs<>nil then bs.Free;
         Cells[1,i]:=Copy(pc,1,j);
         Cells[2,i]:=Fields[3].AsString;
        end;
       Inc(i);
       Next;
       if i>11 then break;
      end;
     Close;
     SQL.Clear;
     SQL.Add('SELECT IDREMCHECK, IDDOC, DESCRIPTION, ORDDATE FROM "'+
      filepath+'\rmcheck.db" WHERE IDDOC='+IntToStr(EditIdDoc)+' ORDER BY IDREMCHECK');
     Open;
     i:=1;
     while not EOF do
      begin
       with RemCheckStringGrid do
        begin
         bs:=nil;
         try
          bs:=TBlobStream.Create(Fields[2] as TBlobField, bmRead);
          bs.Read(pc,bs.Size);
          j:=bs.Size;
         except;
          j:=0;
         end;
         if bs<>nil then bs.Free;
         Cells[1,i]:=Copy(pc,1,j);
         Cells[2,i]:=Fields[3].AsString;
        end;
       Inc(i);
       Next;
       if i>11 then break;
      end;
     Close;
    end;
  end;
end;

function TDocEditForm.SaveRecord:integer;
var
 DocNumber, DocCreator, RegNumber, DocNote:string;
 DocDate, RegDate:TDate;
 i,j,IdDoc, MaxIdDoc, MaxIdDocLine, MaxIdCheck, MaxIdremCheck:integer;
 Bs: TBlobStream;
 s:string;
const
 edf='  ';
begin
 Result:=-1;
 DocNumber:=Trim(DocNumberEdit.Text);
 if DocNumber='' then
  begin ShowMessage('   " "'); DocNumberEdit.SetFocus; exit; end;
 try  DocDate:=StrToDate(DocDateEdit.Text);
 except  ShowMessage(edf); DocDateEdit.SetFocus; exit; end;
 DocCreator:=Trim(DocCreatorEdit.Text);
 if DocCreator='' then
  begin ShowMessage('   " "'); DocCreatorEdit.SetFocus; exit; end;
 RegNumber:=Trim(RegNumberEdit.Text);
 if RegNumber='' then
  begin ShowMessage('   ".  "'); RegNumberEdit.SetFocus; exit; end;
 try  RegDate:=StrToDate(DocDateEdit.Text);
 except  ShowMessage(edf); RegDateEdit.SetFocus; exit; end;
 DocNote:=Trim(DocNoteMemo.Text);
 if DocNote='' then
  begin ShowMessage('   "  "'); DocNoteMemo.SetFocus; exit; end;
 with LineStringGrid do
  begin
  for i:=1 to RowCount do
   if (Cells[1,i]='') and (Cells[2,i]='') and (Cells[3,i]='') and (Cells[4,i]='') and
      (Cells[5,i]='') and (Cells[6,i]='') then continue
   else
    begin
     if Trim(Cells[1,i])='' then
      begin
       DocPageControl.ActivePageIndex:=0;
       ShowMessage('   ""');
       SetFocus;
       Col:=1; Row:=i;
       exit;
      end;
     if Trim(Cells[2,i])='' then
      begin
       DocPageControl.ActivePageIndex:=0;
       ShowMessage('   " "');
       SetFocus;
       Col:=2; Row:=i;
       exit;
      end;
     s:=Cells[3,i]; if Trim(s)='' then s:='-';
     try
      StrToDate(s)
     except
      DocPageControl.ActivePageIndex:=0;
      ShowMessage(edf);
      SetFocus;
      Col:=3; Row:=i;
      exit;
     end;
     s:=Cells[4,i]; if Trim(s)='' then s:='-';
     try
      StrToDate(s)
     except
      DocPageControl.ActivePageIndex:=0;
      ShowMessage(edf);
      SetFocus;
      Col:=4; Row:=i;
      exit;
     end;
     if Trim(Cells[5,i])='' then
      begin
       DocPageControl.ActivePageIndex:=0;
       ShowMessage('   ""');
       SetFocus;
       Col:=5; Row:=i;
       exit;
      end;
     if Trim(Cells[6,i])<>'' then
      try
       StrToDate(Cells[6,i]);
      except
       DocPageControl.ActivePageIndex:=0;
       ShowMessage(edf);
       SetFocus;
       Col:=6; Row:=i;
       exit;
      end;
    end;
  end;
 with CheckStringGrid do
  begin
  for i:=1 to RowCount do
   if (Cells[1,i]='') and (Cells[2,i]='') then continue
   else
    begin
     if Trim(Cells[1,i])='' then
      begin
       DocPageControl.ActivePageIndex:=1;
       ShowMessage('   " "');
       SetFocus;
       Col:=1; Row:=i;
       exit;
      end;
     s:=Cells[2,i]; if Trim(s)='' then s:='-';
     try
      StrToDate(s)
     except
      DocPageControl.ActivePageIndex:=1;
      ShowMessage(edf);
      SetFocus;
      Col:=2; Row:=i;
      exit;
     end;
    end;
  end;
 with RemCheckStringGrid do
  begin
  for i:=1 to RowCount do
   if (Cells[1,i]='') and (Cells[2,i]='') then continue
   else
    begin
     if Trim(Cells[1,i])='' then
      begin
       DocPageControl.ActivePageIndex:=2;
       ShowMessage('   "    "');
       SetFocus;
       Col:=1; Row:=i;
       exit;
      end;
     s:=Cells[2,i]; if Trim(s)='' then s:='-';
     try
      StrToDate(s)
     except
      DocPageControl.ActivePageIndex:=2;
      ShowMessage(edf);
      SetFocus;
      Col:=2; Row:=i;
      exit;
     end;
    end;
  end;
 if SaveFlag then
  begin
   IdDoc:=StrToInt(IdDocEdit.Text);
   with WorkQuery do
    begin
     SQL.Clear;
     SQL.Add('DELETE FROM "'+filepath+'\docline.db" WHERE IDDOC='+IntToStr(IdDoc));
     ExecSQL;
     SQL.Clear;
     SQL.Add('DELETE FROM "'+filepath+'\check.db" WHERE IDDOC='+IntToStr(IdDoc));
     ExecSQL;
     SQL.Clear;
     SQL.Add('DELETE FROM "'+filepath+'\rmcheck.db" WHERE IDDOC='+IntToStr(IdDoc));
     ExecSQL;
    end;
  end
 else IdDoc:=0;
 try
  with WorkQuery do
   begin
    if SaveFlag then MaxIdDoc:=IdDoc
    else
     begin
      SQL.Clear;
      SQL.Add('SELECT MAX(IDDOC) FROM "'+filepath+'\docum.db"');
      Open;
      if RecordCount>0 then
       MaxIdDoc:=Fields[0].AsInteger+1
      else MaxIdDoc:=1;
      Close;
     end;
    SQL.Clear;
    RequestLive:=true;
    SQL.Add('SELECT IDDOC, DOCNUMBER, DOCDATE, DOCCREATOR, REGNUMBER, REGDATE, DOCNOTE, DELFLAG FROM "'+filepath+'\docum.db" WHERE IDDOC='+IntToStr(MaxIdDoc));
    Open;
    if SaveFlag then Edit else Insert;
    Fields[0].AsInteger:=MaxIdDoc;
    Fields[1].AsString:=DocNumber;
    Fields[2].AsDateTime:=DocDate;
    Fields[3].AsString:=DocCreator;
    Fields[4].AsString:=RegNumber;
    Fields[5].AsDateTime:=RegDate;
    bs:=nil;
    try
     bs:=TBlobStream.Create(Fields[6] as TBlobField, bmReadWrite);
     for j:=1 to Length(DocNote) do pc[j]:=DocNote[j];
     bs.Write(pc,Length(DocNote))
    except;
    end;
    if bs<>nil then bs.Free;
    Post;
    Close;
    SQL.Clear;
    SQL.Add('SELECT MAX(IDDOCLINE) FROM "'+filepath+'\docline.db"');
    Open;
    if RecordCount>0 then
     MaxIdDocLine:=Fields[0].AsInteger
    else MaxIdDocLine:=0;
    Close;
    SQL.Clear;
    RequestLive:=true;
    SQL.Add('SELECT IDDOCLINE, IDDOC, TOPERSON, ENTRUST, ENTRUSTDATE, PDATE, PPERSON, PRDATE FROM "'+
     filepath+'\docline.db" WHERE IDDOC='+IntToStr(MaxIdDoc));
    Open;
    with LineStringGrid do
    for i:=1 to RowCount do
     if (Cells[1,i]='') and (Cells[2,i]='') and (Cells[3,i]='') and (Cells[4,i]='') and
        (Cells[5,i]='') and (Cells[6,i]='') then continue
     else
      begin
       Insert;
       Inc(MaxIdDocLine);
       Fields[0].AsInteger:=MaxIdDocLine;
       Fields[1].AsInteger:=MaxIdDoc;
       Fields[2].AsString:=Copy(Trim(Cells[1,i]),1,50);
       Fields[4].AsDateTime:=StrToDate(Cells[3,i]);
       Fields[5].AsDateTime:=StrToDate(Cells[4,i]);
       Fields[6].AsString:=Copy(Trim(Cells[5,i]),1,50);
       if Trim(Cells[6,i])<>'' then
       Fields[7].AsDateTime:=StrToDate(Cells[6,i]);
       bs:=nil;
       try
        bs:=TBlobStream.Create(Fields[3] as TBlobField, bmReadWrite);
        s:=Cells[2,i];
        for j:=1 to Length(s) do pc[j]:=s[j];
        bs.Write(pc,Length(s))
       except;
       end;
       if bs<>nil then bs.Free;
       Post;
      end;
    Close;
    SQL.Clear;
    SQL.Add('SELECT MAX(IDCHECK) FROM "'+filepath+'\check.db"');
    Open;
    if RecordCount>0 then
     MaxIdCheck:=Fields[0].AsInteger
    else MaxIdCheck:=0;
    Close;
    SQL.Clear;
    RequestLive:=true;
    SQL.Add('SELECT IDCHECK, IDDOC, DESCRIPTION, CHECKDATE FROM "'+
     filepath+'\check.db" WHERE IDDOC='+IntToStr(MaxIdDoc));
    Open;
    with CheckStringGrid do
    for i:=1 to RowCount do
     if (Cells[1,i]='') and (Cells[2,i]='') then continue
     else
      begin
       Insert;
       Inc(MaxIdCheck);
       Fields[0].AsInteger:=MaxIdCheck;
       Fields[1].AsInteger:=MaxIdDoc;
       Fields[3].AsDateTime:=StrToDate(Cells[2,i]);
       bs:=nil;
       try
        bs:=TBlobStream.Create(Fields[2] as TBlobField, bmReadWrite);
        s:=Cells[1,i];
        for j:=1 to Length(s) do pc[j]:=s[j];
        bs.Write(pc,Length(s))
       except;
       end;
       if bs<>nil then bs.Free;
       Post;
      end;
    Close;
    SQL.Clear;
    SQL.Add('SELECT MAX(IDREMCHECK) FROM "'+filepath+'\rmcheck.db"');
    Open;
    if RecordCount>0 then
     MaxIdRemCheck:=Fields[0].AsInteger
    else MaxIdRemCheck:=0;
    Close;
    SQL.Clear;
    RequestLive:=true;
    SQL.Add('SELECT IDREMCHECK, IDDOC, DESCRIPTION, ORDDATE FROM "'+
     filepath+'\rmcheck.db" WHERE IDDOC='+IntToStr(MaxIdDoc));
    Open;
    with RemCheckStringGrid do
    for i:=1 to RowCount do
     if (Cells[1,i]='') and (Cells[2,i]='') then continue
     else
      begin
       Insert;
       Inc(MaxIdRemCheck);
       Fields[0].AsInteger:=MaxIdRemCheck;
       Fields[1].AsInteger:=MaxIdDoc;
       Fields[3].AsDateTime:=StrToDate(Cells[2,i]);
       bs:=nil;
       try
        bs:=TBlobStream.Create(Fields[2] as TBlobField, bmReadWrite);
        s:=Cells[1,i];
        for j:=1 to Length(s) do pc[j]:=s[j];
        bs.Write(pc,Length(s))
       except;
       end;
       if bs<>nil then bs.Free;
       Post;
      end;
    Close;
   end;
  EditIdDoc:=MaxIdDoc;
  IdDocEdit.Text:=IntToStr(MaxIdDoc);
   SaveFlag:=true;
  Result:=0;
 except
  ShowMessage('    ');
 end;
end;

procedure TDocEditForm.CancelButtonClick(Sender: TObject);
begin
 Close;
end;

procedure TDocEditForm.SaveButtonClick(Sender: TObject);
begin
 SaveRecord;
end;

procedure TDocEditForm.OKButtonClick(Sender: TObject);
begin
 fok:=true;
 if SaveRecord=0 then Close;
end;

procedure TDocEditForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
var
 i:integer;
begin
 if not fok then
  begin
   i:=MessageBox(Handle,'   ?','',MB_YESNOCANCEL);
   if i=IDYES then if SaveRecord<>0 then Action:=caNone else
   else
    if i=IDCANCEL then Action:=caNone;
  end;
end;

end.
