unit docregu;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Grids, DBGrids, StdCtrls, Menus, ToolWin, DB, DBTables,
  ImgList, ShellAPI, ExtCtrls, inifiles, OleServer, Excel2000;

const
 IDI_MYICON=999;
 MYWM_NOTIFYICON=WM_MOUSEMOVE+400;
type
  TRegDocForm = class(TForm)
    DocRegDataSource: TDataSource;
    DocRegQuery: TQuery;
    DocRegMenu: TMainMenu;
    ServiceMenu: TMenuItem;
    HelpMenu: TMenuItem;
    SMMode: TMenuItem;
    SMModeEdit: TMenuItem;
    SMModeControl: TMenuItem;
    SMOption: TMenuItem;
    SMExit: TMenuItem;
    SMSep: TMenuItem;
    HMAbout: TMenuItem;
    EditGroupBox: TGroupBox;
    DocRegDBGrid: TDBGrid;
    DocRegQueryIDDOC: TIntegerField;
    DocRegQueryDOCNUMBER: TStringField;
    DocRegQueryDOCDATE: TDateField;
    DocRegQueryDOCCREATOR: TStringField;
    DocRegQueryREGNUMBER: TStringField;
    DocRegQueryREGDATE: TDateField;
    DocRegQueryDOCNOTE: TMemoField;
    MainToolBar: TToolBar;
    EditModeToolButton: TToolButton;
    ControlModeToolButton: TToolButton;
    SepToolButton: TToolButton;
    RecEditToolButton: TToolButton;
    RecAddToolButton: TToolButton;
    RecDelToolButton: TToolButton;
    DocRegImageList: TImageList;
    EditMenu: TMenuItem;
    EMEditRec: TMenuItem;
    EMAddRec: TMenuItem;
    EMDelRec: TMenuItem;
    ControlGroupBox: TGroupBox;
    ControlDBGrid: TDBGrid;
    DocControlQuery: TQuery;
    DocControlDataSource: TDataSource;
    ModeLabel: TLabel;
    DocControlQueryCOLOR: TIntegerField;
    DocControlQueryIDDOC: TIntegerField;
    DocControlQueryDOCNUMBER: TStringField;
    DocControlQueryDOCDATE: TDateField;
    DocControlQueryDOCCREATOR: TStringField;
    DocControlQueryREGNUMBER: TStringField;
    DocControlQueryREGDATE: TDateField;
    DocControlQueryDOCNOTE: TMemoField;
    DocControlQueryTOPERSON: TStringField;
    DocControlQueryENTRUST: TMemoField;
    DocControlQueryENTRUSTDATE: TDateField;
    DocControlQueryPDATE: TDateField;
    DocControlQueryPPERSON: TStringField;
    DocControlQueryPRDATE: TDateField;
    ControlPopupMenu: TPopupMenu;
    CPPPR: TMenuItem;
    CPPSep: TMenuItem;
    CPPInfo: TMenuItem;
    CPPEditDoc: TMenuItem;
    DocRegPopupMenu: TPopupMenu;
    DRPEditRec: TMenuItem;
    DRPAddRec: TMenuItem;
    DRPDelRec: TMenuItem;
    TrayPopupMenu: TPopupMenu;
    DocControlQueryIDDOCLINE: TIntegerField;
    DateLabel: TLabel;
    MainTimer: TTimer;
    IconImageList: TImageList;
    SMReportExcel: TMenuItem;
    WorkQuery: TQuery;
    MainExcelApplication: TExcelApplication;
    procedure FormCreate(Sender: TObject);
    procedure ControlModeToolButtonClick(Sender: TObject);
    procedure EditModeToolButtonClick(Sender: TObject);
    procedure SMExitClick(Sender: TObject);
    procedure RecAddToolButtonClick(Sender: TObject);
    procedure RecEditToolButtonClick(Sender: TObject);
    procedure RecDelToolButtonClick(Sender: TObject);
    procedure HMAboutClick(Sender: TObject);
    procedure DocControlQueryCalcFields(DataSet: TDataSet);
    procedure CPPEditDocClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure MainTimerTimer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SMOptionClick(Sender: TObject);
    procedure CPPInfoClick(Sender: TObject);
    procedure CPPPRClick(Sender: TObject);
    procedure SMReportExcelClick(Sender: TObject);
  private
    procedure MenuEnabled;
    procedure RefreshIcon;
    function MyTaskBarAddIcon(Wnd:HWND;uId:UINT;Icon:HICON;lpszTip:LPSTR):BOOL;
    function MyTaskBarModifyIcon(Wnd:HWND;uId:UINT;Icon:HICON;lpszTip:LPSTR):BOOL;
    function MyTaskBarDeleteIcon(Wnd:HWND;uID:UINT):BOOL;
    procedure On_MYWM_NOTIFYICON(var Msg:TMessage);message MYWM_NOTIFYICON;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  RegDocForm: TRegDocForm;
  p:TPoint;
  EditIdDocLine:integer;
  ti:TIcon;
  ifile:TIniFile;
  EditMode:boolean=true;
  ControlDaysCount:integer=5;
  ExitFlag:boolean=false;
  MyIcon:HICON;
  IconNumber:integer=0;
  IconText:string='';
  StartFlag:boolean=true;

implementation

uses doceditu, aboutu, docsetu, docdescu, docpdu, docrepu;

{$R *.dfm}

function TRegDocForm.MyTaskBarAddIcon
 (Wnd:HWND;uId:UINT;Icon:HICON;lpszTip:LPSTR):BOOL;
var
 Res:BOOL;
 TNID:TNOTIFYICONDATA;
begin
 TNID.cbSize:= SizeOf(TNOTIFYICONDATA);
 TNID.Wnd:=wnd;
 TNID.uID:=uID;
 TNID.uFlags:=NIF_MESSAGE or NIF_ICON or NIF_TIP;
 TNID.uCallbackMessage:=MYWM_NOTIFYICON;
 TNID.hIcon:=Icon;
 if lpszTip<>'' then
  lstrCpyn(TNID.szTip,lpszTip,SizeOf(TNID.szTip))
 else
  TNID.szTip[0]:=#0;
 Res:=Shell_NotifyIcon(NIM_ADD,@TNID);
 if Icon<>0 then DestroyIcon(Icon);
 MyTaskBarAddIcon:=Res;
end;

function TRegDocForm.MyTaskBarModifyIcon
 (Wnd:HWND;uId:UINT;Icon:HICON;lpszTip:LPSTR):BOOL;
var
 Res:BOOL;
 TNID:TNOTIFYICONDATA;
begin
 TNID.cbSize:= SizeOf(TNOTIFYICONDATA);
 TNID.Wnd:=wnd;
 TNID.uID:=uID;
 TNID.uFlags:=NIF_MESSAGE or NIF_ICON or NIF_TIP;
 TNID.uCallbackMessage:=MYWM_NOTIFYICON;
 TNID.hIcon:=Icon;
 if lpszTip<>'' then
  lstrCpyn(TNID.szTip,lpszTip,SizeOf(TNID.szTip))
 else
  TNID.szTip[0]:=#0;
 Res:=Shell_NotifyIcon(NIM_Modify,@TNID);
 if Icon<>0 then DestroyIcon(Icon);
 MyTaskBarModifyIcon:=Res;
end;

function TRegDocForm.MyTaskBarDeleteIcon(Wnd:HWND;uID:UINT):BOOL;
var
 Res:BOOL;
 TNID:TNOTIFYICONDATA;
begin
 TNID.cbSize:=SizeOf(TNOTIFYICONDATA);
 TNID.Wnd:=Wnd;
 TNID.uID:=uID;
 Res:=Shell_NotifyIcon(NIM_DELETE,@TNID);
 MyTaskBarDeleteIcon:=Res;
end;

procedure TRegDocForm.On_MYWM_NOTIFYICON(var Msg:TMessage);
var
 uID:UINT;
 uMouseMsg:UINT;
begin
 uID:=UINT(Msg.wParam);
 uMouseMsg:=UINT(Msg.lParam);
 if (uID=IDI_MYICON) then
  begin
   if (uMouseMsg=WM_RBUTTONDOWN) then GetCursorPos(p);
   if (uMouseMsg=WM_RBUTTONUP) then
    TrayPopupMenu.Popup(p.x,p.y);
   if (uMouseMsg=WM_LBUTTONDBLCLK) then
    begin
     ShowWindow(Handle,SW_SHOWNORMAL);
     SetForeGroundWindow(Handle);
    end;
  end;
end;

procedure TRegDocForm.FormCreate(Sender: TObject);
var
 s:string;
begin
 ti:=TIcon.Create;
 ifile:=TIniFile.Create('docreg.ini');
 try
  RedDay:=ifile.ReadInteger('Alarm','Red',RedDay);
  YellowDay:=ifile.ReadInteger('Alarm','Yellow',YellowDay);
  GreenDay:=ifile.ReadInteger('Alarm','Green',GreenDay);
 finally
  ifile.Free;
 end;
 IconNumber:=0;
 IconText:=Caption;
 MyIcon:=LoadIcon(hInstance,'MAINICON');
 MyTaskBarAddIcon(Handle,IDI_MYICON,MyIcon,PChar(IconText));
 s:=ExtractFilePath(ParamStr(0));
 if s[length(s)]<>'\' then s:=s+'\';
 s:=s+'Base';
 filepath:=s;
 DocRegQuery.SQL.Clear;
 DocRegQuery.SQL.Add(
 'SELECT IDDOC, DOCNUMBER, DOCDATE, DOCCREATOR, REGNUMBER,'+
 'REGDATE, DOCNOTE FROM "'+filepath+'\docum.db" WHERE DELFLAG IS NULL');
 DocRegQuery.Open;
 MenuEnabled;
 ModeLabel.Caption:='   ';
 DateLabel.Caption:=DateToStr(Date);
 ControlDBGrid.ColorColumnIndex:=6;
 ControlModeToolButtonClick(Self);
 MainTimer.Enabled:=true;
end;

procedure TRegDocForm.MenuEnabled;
begin
 EditMenu.Enabled:=EditMode;
 EMEditRec.Enabled:=EditMode and (DocRegQuery.RecordCount>0);
 EMAddRec.Enabled:=EditMode;
 EMDelRec.Enabled:=EditMode and (DocRegQuery.RecordCount>0);
 RecEditToolButton.Enabled:=EMEditRec.Enabled;
 RecAddToolButton.Enabled:=EMAddRec.Enabled;
 RecDelToolButton.Enabled:=EMDelRec.Enabled;
 if not EditMode then
  begin
   CPPPR.Enabled:=DocControlQuery.RecordCount>0;
   CPPInfo.Enabled:=DocControlQuery.RecordCount>0;
   CPPEditDoc.Enabled:=DocControlQuery.RecordCount>0;
  end;
end;

procedure TRegDocForm.ControlModeToolButtonClick(Sender: TObject);
begin
 EditModeToolButton.Down:=false;
 ControlModeToolButton.Down:=true;
 if not EditMode then exit;
 ModeLabel.Caption:='   ';
 DateLabel.Caption:=DateToStr(Date);
 EditMode:=false;
 SMModeEdit.Checked:=false;
 SMModeControl.Checked:=true;
 EditGroupBox.Visible:=false;
 ControlGroupBox.Visible:=true;
 if Visible then
 try ControlDBGrid.SetFocus;
 except end;
 EditIdDoc:=DocRegQuery.Fields[0].AsInteger;
 with DocControlQuery do
  begin
   SQL.Clear;
   SQL.Add(
    'SELECT DL.IDDOC, D.DOCNUMBER, D.DOCDATE, D.DOCCREATOR, D.REGNUMBER, D.REGDATE, D.DOCNOTE, '+
    'DL.TOPERSON, DL.ENTRUST, DL.ENTRUSTDATE, DL.PDATE, DL.PPERSON, DL.PRDATE, DL.IDDOCLINE '+
    'FROM "'+filepath+'\docum.db" D, "'+filepath+'\docline.db" DL '+
    'WHERE D.DELFLAG IS NULL AND DL.IDDOC=D.IDDOC AND DL.PRDATE IS NULL AND DL.PDATE-'+
    IntToStr(GreenDay)+'<"'+DateTimeToStr(Date)+'" ORDER BY DL.PDATE, DL.IDDOC');
   Open;
   RefreshIcon;
  end;
 MenuEnabled;
end;

procedure TRegDocForm.RefreshIcon;
var
 s1:string;
 n:integer;
begin
 with DocControlQuery do
  begin
   if RecordCount>0 then
    begin
     n:=Trunc(DocControlQueryPDATE.AsDateTime-Date);
     if n<0 then begin IconNumber:=1; IconText:='   '; end
     else
      begin
       if n<RedDay then IconNumber:=1
       else if n<YellowDay then IconNumber:=2
       else if n<GreenDay then IconNumber:=3;
       if n=0 then s1:=''
       else if n mod 10=1 then s1:=''
       else if (n mod 10>1) and (n mod 10<5) then s1:=''
       else s1:='';
       IconText:=' '+IntToStr(n)+' '+s1+'   ';
      end;
    end
   else
    begin
     IconNumber:=0;
     IconText:=Caption;
     MyIcon:=LoadIcon(hInstance,'MAINICON');
     MyTaskBarModifyIcon(RegDocForm.Handle,IDI_MYICON,MyIcon,PChar(IconText));
    end;
 end;
end;

procedure TRegDocForm.EditModeToolButtonClick(Sender: TObject);
begin
 EditModeToolButton.Down:=true;
 ControlModeToolButton.Down:=false;
 if EditMode then exit;
 ModeLabel.Caption:='   ';
 DateLabel.Caption:=DateToStr(Date);
 DocRegQuery.Close;
 DocRegQuery.Open;
 DocRegQuery.Locate('IDDOC',EditIdDoc,[loPartialKey]);
 EditMode:=true;
 SMModeEdit.Checked:=true;
 SMModeControl.Checked:=false;
 MenuEnabled;
 EditGroupBox.Visible:=true;
 ControlGroupBox.Visible:=false;
 try DocRegDBGrid.SetFocus;
 except end;
end;

procedure TRegDocForm.SMExitClick(Sender: TObject);
begin
 ExitFlag:=true;
 Close;
end;

procedure TRegDocForm.RecAddToolButtonClick(Sender: TObject);
begin
 NewRec:=true;
 DocEditForm.ShowModal;
 DocRegQuery.Close;
 DocRegQuery.Open;
 DocRegQuery.Locate('IDDOC',EditIdDoc,[]);
 EditIdDocLine:=DocControlQuery.Fields[14].AsInteger;
 DocControlQuery.Close;
 DocControlQuery.Open;
 RefreshIcon;
 DocControlQuery.Locate('IDDOCLINE',EditIdDocLine,[]);
 MenuEnabled;
end;

procedure TRegDocForm.RecEditToolButtonClick(Sender: TObject);
begin
 if not EMEditRec.Enabled then exit;
 EditIdDoc:=DocRegQuery.Fields[0].AsInteger;
 NewRec:=false;
 DocEditForm.ShowModal;
 DocRegQuery.Close;
 DocRegQuery.Open;
 DocRegQuery.Locate('IDDOC',EditIdDoc,[]);
 EditIdDocLine:=DocControlQuery.Fields[14].AsInteger;
 DocControlQuery.Close;
 DocControlQuery.Open;
 RefreshIcon;
 DocControlQuery.Locate('IDDOCLINE',EditIdDocLine,[]);
 MenuEnabled;
end;

procedure TRegDocForm.RecDelToolButtonClick(Sender: TObject);
var
 i,j:integer;
begin
 i:=MessageBox(Handle,'    ?','',MB_YESNO);
 if i=IDYES then
  begin
   with DocEditForm.WorkQuery do
    begin
     SQL.Clear;
     j:=DocRegQuery.Fields[0].AsInteger;
     SQL.Add('UPDATE "'+filepath+'\docum.db" SET DELFLAG=1 WHERE IDDOC='+IntToStr(j));
     ExecSQL;
    end;
   DocRegQuery.Close;
   DocRegQuery.Open;
   DocRegQuery.Locate('IDDOC',j,[loPartialKey]);
   EditIdDocLine:=DocControlQuery.Fields[14].AsInteger;
   DocControlQuery.Close;
   DocControlQuery.Open;
   RefreshIcon;
   DocControlQuery.Locate('IDDOCLINE',EditIdDocLine,[]);
  end;
end;

procedure TRegDocForm.HMAboutClick(Sender: TObject);
begin
 AboutForm.ShowModal;
end;

procedure TRegDocForm.DocControlQueryCalcFields(DataSet: TDataSet);
var
 n,c:integer;
begin
  n:=Trunc(DocControlQueryPDATE.AsDateTime-Date);
  if n<0 then c:=-250000000
  else if n<RedDay then c:=200000000
  else if n<YellowDay then c:=256200000
  else if n<GreenDay then c:=00200000
  else c:=0;
  DOCControlQueryColor.AsInteger:=c;
end;

procedure TRegDocForm.CPPEditDocClick(Sender: TObject);
begin
 EditIdDoc:=DocControlQuery.Fields[0].AsInteger;
 EditIdDocLine:=DocControlQuery.Fields[14].AsInteger;
 NewRec:=false;
 DocEditForm.ShowModal;
 DocControlQuery.Close;
 DocControlQuery.Open;
 RefreshIcon;
 DocControlQuery.Locate('IDDOCLINE',EditIdDocLine,[]);
 MenuEnabled;
end;

procedure TRegDocForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 if not ExitFlag then
  begin
   if EditMode then
    ControlModeToolButtonClick(Self);
   Action:=caNone;
   ShowWindow(Handle,SW_HIDE);
  end
 else
  begin
   ifile:=TIniFile.Create('docreg.ini');
   try
    ifile.WriteInteger('Alarm','Red',RedDay);
    ifile.WriteInteger('Alarm','Yellow',YellowDay);
    ifile.WriteInteger('Alarm','Green',GreenDay);
   finally
    ifile.Free;
   end;
  end;
end;

procedure TRegDocForm.FormDestroy(Sender: TObject);
begin
 ti.Free;
 MyTaskBarDeleteIcon(Handle,IDI_MYICON);
end;

procedure TRegDocForm.MainTimerTimer(Sender: TObject);
begin
 if IconNumber>0 then
  begin
   if MainTimer.Tag=0 then
    begin
     MainTimer.Tag:=1;
     IconImageList.GetIcon((IconNumber-1)*2,ti);
     MyIcon:=ti.Handle;
     ti.ReleaseHandle;
    end
   else
    begin
     MainTimer.Tag:=0;
     IconImageList.GetIcon((IconNumber-1)*2+1,ti);
     MyIcon:=ti.Handle;
     ti.ReleaseHandle;
    end;
   MyTaskBarModifyIcon(RegDocForm.Handle,IDI_MYICON,MyIcon,PChar(IconText));
  end;
end;

procedure TRegDocForm.FormActivate(Sender: TObject);
begin
 if StartFlag then
  begin
   ShowWindow(Application.Handle,SW_HIDE);
   ShowWindow(Handle,SW_HIDE);
   StartFlag:=false;
  end;
end;

procedure TRegDocForm.SMOptionClick(Sender: TObject);
begin
 SetupForm.ShowModal;
 if OkBF then
  begin
   EditMode:=true;
   ControlModeToolButtonClick(Self);
  end;
end;

procedure TRegDocForm.CPPInfoClick(Sender: TObject);
begin
 with DescForm.DescMemo.Lines do
  begin
   Clear;
   Add(' : '+DocControlQueryDOCNUMBER.AsString);
   Add(' : '+DocControlQueryDOCDATE.AsString);
   Add(' : '+DocControlQueryDOCCREATOR.AsString);
   Add('.  : '+DocControlQueryREGNUMBER.AsString);
   Add('.  : '+DocControlQueryREGDATE.AsString);
   Add(' : '+DocControlQueryDOCNOTE.AsString);
   Add('************');
   Add(' : '+DocControlQueryTOPERSON.AsString);
   Add(' : '+DocControlQueryENTRUST.AsString);
   Add(' : '+DocControlQueryENTRUSTDATE.AsString);
   Add(' : '+DocControlQueryPDATE.AsString);
   Add(': '+DocControlQueryPPERSON.AsString);
  end;
 DescForm.ShowModal;
end;

procedure TRegDocForm.CPPPRClick(Sender: TObject);
var
 j:integer;
begin
 PDateForm.ShowModal;
 if OKPD then
  begin
   with DocEditForm.WorkQuery do
    try
     SQL.Clear;
     j:=DocControlQueryIDDOCLINE.AsInteger;
     SQL.Add('UPDATE "'+filepath+'\docline.db" SET PRDATE="'+DateToStr(PDate)+'" WHERE IDDOCLINE='+IntToStr(j));
     ExecSQL;
    except
    end;
   EditMode:=true;
   ControlModeToolButtonClick(Self);
  end;
end;

procedure TRegDocForm.SMReportExcelClick(Sender: TObject);
var
 i,k,r:integer;
 s1,s2,s3:string;
begin
 ReportForm.ShowModal;
 if RepOk then
 try
 Screen.Cursor:=crHourGlass;
 WorkQuery.SQL.Clear;
 WorkQuery.SQL.Add(
    'SELECT DL.IDDOC, D.DOCNUMBER, D.DOCDATE, D.DOCCREATOR, D.REGNUMBER, D.REGDATE, D.DOCNOTE, '+
    'DL.TOPERSON, DL.ENTRUST, DL.ENTRUSTDATE, DL.PDATE, DL.PPERSON, DL.PRDATE, DL.IDDOCLINE '+
    'FROM "'+filepath+'\docum.db" D, "'+filepath+'\docline.db" DL '+
    'WHERE D.DELFLAG IS NULL AND DL.IDDOC=D.IDDOC AND D.REGDATE>="'+DateTimeToStr(BegDate)+
     '" AND D.REGDATE<="'+DateTimeToStr(EndDate)+'" '+
    'ORDER BY D.REGDATE, D.REGNUMBER, DL.IDDOC');
 WorkQuery.Open;
 r:=WorkQuery.RecordCount;
 MainExcelApplication.Connect;
 try
 with MainExcelApplication do
  begin
   Workbooks.Add('',1);
   s1:=IntToStr(r+3);
   if BegDate=StrToDate('01.01.1900') then s2:='_____' else s2:=DateToStr(BegDate);
   if EndDate=StrToDate('01.01.2090') then s3:='_____' else s3:=DateToStr(EndDate);
   Range['B1','B1'].Value2:='      '+s2+'  '+s3;
   Range['B1','B1'].ColumnWidth:=10;
   Range['B1','B1'].RowHeight:=20;
   Range['C1','G1'].ColumnWidth:=17;
   Range['H1','H1'].ColumnWidth:=50;
   Range['I1','N1'].ColumnWidth:=17;
   Range['B2','B2'].Value2:='';
   Range['B2','B'+s1].NumberFormat:='0';
   Range['C2','C2'].Value2:=' .';
   Range['C2','C'+s1].NumberFormat:='@';
   Range['D2','D2'].Value2:=' .';
   Range['D2','D'+s1].NumberFormat:='..;@';
   Range['E2','E2'].Value2:=' ';
   Range['E2','E'+s1].NumberFormat:='@';
   Range['E2','E'+s1].WrapText:=true;
   Range['F2','F2'].Value2:='. ';
   Range['F2','F'+s1].NumberFormat:='@';
   Range['G2','G2'].Value2:='. ';
   Range['G2','G'+s1].NumberFormat:='..;@';
   Range['H2','H2'].Value2:=' ';
   Range['H2','H'+s1].NumberFormat:='@';
   Range['H2','H'+s1].WrapText:=true;
   Range['I2','I2'].Value2:=' ';
   Range['I2','I'+s1].NumberFormat:='@';
   Range['J2','J2'].Value2:='';
   Range['J2','J'+s1].NumberFormat:='@';
   Range['K2','K2'].Value2:=' ';
   Range['K2','K'+s1].NumberFormat:='..;@';
   Range['L2','L2'].Value2:=' ';
   Range['L2','L'+s1].NumberFormat:='..;@';
   Range['M2','M2'].Value2:='';
   Range['M2','M'+s1].NumberFormat:='@';
   Range['N2','N2'].Value2:=' .';
   Range['N2','N'+s1].NumberFormat:='..;@';
   Range['B1','N'+s1].Font.Bold:=1;
   Range['B1','N'+s1].VerticalAlignment:=xlTop;
   Range['B2','N2'].HorizontalAlignment:=xlCenter;
   for i:=1 to 4 do
    begin
     Range['B2','N'+s1].Borders.Item[i].LineStyle:=xlContinuous;
     Range['B2','N'+s1].Borders.Item[i].Weight:=xlThin;
     Range['B2','N'+s1].Borders.Item[i].ColorIndex:=xlAutomatic;
     Range['B2','N'+s1].Borders.Item[i].Color:=0;
    end;
   k:=3;
   while not WorkQuery.Eof do
    begin
     s1:=IntToStr(k);
     Range['B'+s1,'B'+s1].Value2:=k-2;
     Range['C'+s1,'C'+s1].Value2:=WorkQuery.Fields[1].AsString;
     Range['D'+s1,'D'+s1].Value2:=WorkQuery.Fields[2].AsDateTime;
     Range['E'+s1,'E'+s1].Value2:=WorkQuery.Fields[3].AsString;
     Range['F'+s1,'F'+s1].Value2:=WorkQuery.Fields[4].AsString;
     Range['G'+s1,'G'+s1].Value2:=WorkQuery.Fields[5].AsDateTime;
     Range['H'+s1,'H'+s1].Value2:=WorkQuery.Fields[6].AsString;
     Range['I'+s1,'I'+s1].Value2:=WorkQuery.Fields[7].AsString;
     Range['J'+s1,'J'+s1].Value2:=WorkQuery.Fields[8].AsString;
     Range['K'+s1,'K'+s1].Value2:=WorkQuery.Fields[9].AsDateTime;
     Range['L'+s1,'L'+s1].Value2:=WorkQuery.Fields[10].AsDateTime;
     Range['M'+s1,'M'+s1].Value2:=WorkQuery.Fields[11].AsString;
     if WorkQuery.Fields[12].AsDateTime=0 then Range['N'+s1,'N'+s1].Value2:='' else
     Range['N'+s1,'N'+s1].Value2:=WorkQuery.Fields[12].AsDateTime;
     WorkQuery.Next;
     Inc(k);
    end;
   WorkQuery.Close;
  end;
 MainExcelApplication.Visible[1]:=true;
 MainExcelApplication.Disconnect;
 Screen.Cursor:=crDefault;
 except
  MainExcelApplication.Visible[1]:=true;
  MainExcelApplication.Disconnect;
  Screen.Cursor:=crDefault;
 end;
 except
  Screen.Cursor:=crDefault;
 end;

end;

end.
