unit fontnumu;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, DateUtils, StdCtrls;

type
  TMainForm = class(TForm)
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
   procedure Delay(msecs: dword);
   procedure SetRGBPalette(clrindex, r,g,b:byte);
   function GetMaxX:integer;
   function GetMaxY:integer;
   procedure SetColor(clrindex:byte);
   procedure SetBrushColor(clrindex:byte);
   procedure PutPixel(x,y:integer;clrindex:byte);
   procedure Bar(x1,y1,x2,y2:integer);
   procedure WriteByte(x0,y0,Clr:Integer;i:Byte);
   procedure WriteNumber(x0,y0,Clr,DXChar:Integer;st:string);
   procedure Draw;
    { Private declarations }
  public
   Colors:array [0..256] of TColor;
   BreakFlag:boolean;
   MainImage:TBitmap;
  end;

var
  MainForm: TMainForm;

implementation


{I fonts.pas }

{$R *.dfm}

procedure TMainForm.Delay(msecs: dword);
var
 FirstTickCount: dword;
begin { Delay }
 FirstTickCount:=GetTickCount;
 repeat
  Application.ProcessMessages; {allowing access to other controls, etc.}
 until ((GetTickCount-FirstTickCount)>=msecs);
end; { Delay }

procedure TMainForm.Draw;
begin
 BitBlt(Canvas.Handle,0,0,Width,Height,MainImage.Canvas.Handle,0,0,SRCCOPY);
end;

procedure TMainForm.SetRGBPalette(clrindex, r,g,b:byte);
begin
 Colors[clrindex]:=RGB(r,g,b);
end;

function TMainForm.GetMaxX:integer;
begin
 Result:=MainImage.Width;
end;

function TMainForm.GetMaxY:integer;
begin
 Result:=MainImage.Height;
end;

procedure TMainForm.SetColor(clrindex:byte);
begin
 MainImage.Canvas.Pen.Color:=Colors[clrindex];
 MainImage.Canvas.Brush.Color:=Colors[clrindex];
end;

procedure TMainForm.SetBrushColor(clrindex:byte);
begin
 MainImage.Canvas.Brush.Color:=Colors[clrindex];
end;

procedure TMainForm.PutPixel(x,y:integer;clrindex:byte);
begin
 MainImage.Canvas.Pixels[x,y]:=Colors[clrindex];
end;

procedure TMainForm.Bar(x1,y1,x2,y2:integer);
begin
 MainImage.Canvas.FillRect(Rect(x1,y1,x2,y2));
end;

procedure TMainForm.WriteByte(x0,y0,Clr:Integer;i:Byte);
const
 Font:array[0..9,1..14] of Byte=
(($00,$00,$7E,$BD,$C3,$C3,$C3,$00,$C3,$C3,$BD,$7E,$00,$00),
 ($00,$00,$00,$01,$03,$03,$03,$00,$03,$03,$01,$00,$00,$00),
 ($00,$00,$7E,$3D,$03,$03,$7D,$BE,$C0,$C0,$BC,$7E,$00,$00),
 ($00,$00,$7E,$3D,$03,$03,$3D,$3C,$03,$03,$3D,$7E,$00,$00),
 ($00,$00,$00,$82,$C6,$C6,$BA,$7C,$06,$06,$02,$00,$00,$00),
 ($00,$00,$7E,$BC,$C0,$C0,$BE,$7D,$03,$03,$3D,$7E,$00,$00),
 ($00,$00,$7E,$BC,$C0,$C0,$BE,$7D,$C3,$C3,$BD,$7E,$00,$00),
 ($00,$00,$FE,$7D,$03,$03,$03,$00,$03,$03,$01,$00,$00,$00),
 ($00,$00,$7E,$BD,$C3,$C3,$BD,$7E,$C3,$C3,$BD,$7E,$00,$00),
 ($00,$00,$7E,$BD,$C3,$C3,$BD,$7E,$03,$03,$3D,$7E,$00,$00));
var
 j,k,b,b1:Integer;
begin
 if i>9 then i:=9;
 for j:=1 to 14 do
  begin
   b:=Font[i,j];
   if b>0 then
    for k:=8 downto 1 do
     begin
      b1:=b div 2;
      if b-b1*2>0 then PutPixel(x0+k,y0+j-1,Clr);
      b:=b1;
     end;
  end;
end;

procedure TMainForm.WriteNumber(x0,y0,Clr,DXChar:Integer;st:string);
var
 x1,NErr:Integer;
 i,j:Byte;
begin
 x1:=x0;
 for i:=1 to Length(st) do
  begin
   Val(st[i],j,NErr);
   if NErr=0 then
    begin
     WriteByte(x1,y0,Clr,j);
     x1:=x1+8+DXChar;
    end;
  end;
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    27:Close;
  end;
end;

procedure TMainForm.FormActivate(Sender: TObject);
var
 i,j:integer;
 st:string;
begin
 SetRGBPalette(0,0,0,0); {  }
 SetRGBPalette(1,0,0,$80); { Ҹ- }
 SetRGBPalette(2,0,$80,0); { Ҹ- }
 SetRGBPalette(3,0,$80,$80); {  }
 SetRGBPalette(4,$80,0,0); {  }
 SetRGBPalette(5,$80,0,$80); {  }
 SetRGBPalette(6,$80,$80,0); {  }
 SetRGBPalette(7,$C0,$C0,$C0); { - }
 SetRGBPalette(8,$80,$80,$80); { - }
 SetRGBPalette(9,0,0,$FF); {  }
 SetRGBPalette(10,0,$FF,0); {  }
 SetRGBPalette(11,0,$FF,$FF); {  }
 SetRGBPalette(12,$FF,0,0); {  }
 SetRGBPalette(13,$FF,0,$FF); {  }
 SetRGBPalette(14,$FF,$FF,0); {  }
 SetRGBPalette(15,$FF,$FF,$FF); {  }
 SetBrushColor(0);
 Bar(0,0,GetMaxX,GetMaxY);
 Randomize;
 for i:=0 to GetMaxY div 20 do
  for j:=0 to GetMaxX div 20 do
   begin
    Str(Random(10),st);
    WriteNumber(j*20,i*20,10,2,st);
   end;
 Randomize;
 repeat
  j:=Random(GetMaxX div 20+1);
  i:=Random(GetMaxY div 20+1);
  Bar(j*20,i*20,j*20+12,i*20+12);
  Str(Random(10),st);
  WriteNumber(j*20,i*20,10,2,st);
  Draw;
  Delay(1);
 until BreakFlag;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 BreakFlag:=true;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
 MainImage:=TBitmap.Create;
 MainImage.Width:=640;
 MainImage.Height:=480;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
 MainImage.Free;
end;

procedure TMainForm.FormPaint(Sender: TObject);
begin
 Draw;
end;

end.
