unit moveimgu;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    MyButton: TButton;
    procedure MyButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  TRec=record
   Id:integer;
   R:TRect;
   Clr:TColor;
   Cmt:string;
   Dat:TDateTime;
   sFlag:boolean;
   CmtFlag:boolean;
   RCmt:TRect;
   CmtClr:TColor;
  end;

  TNewImage=class(TImage)
  private
   OriginBitmap:TBitmap;
   FMode:integer;
   FState:integer;
   X0,Y0,X1,Y1:integer;
   FCount:integer;
   W,H:integer;
   Style1,Style2:TPenStyle;
   PenWidth:integer;
   procedure SetOriginWidth(Value:integer);
   procedure SetOriginHeight(Value:integer);
   procedure DrawRect(X1,Y1,X2,Y2:integer);
   procedure ImageMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer); dynamic;
   procedure ImageMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer); dynamic;
   procedure ImageMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer); dynamic;
  public
   Rects:array of TRec;
   DPI:real;
   constructor Create(AOwner: TComponent); override;
   destructor Destroy; override;
   procedure SetOriginBitmap;
   procedure RedrawImage;
   procedure DelSelected;
   procedure Delete(Index:integer);
   procedure Select(Index:integer);
   procedure UnSelect(Index:integer);
  published
   property Mode:integer read FMode write FMode;
   property State:integer read FState write FState;
   property Count:integer read FCount write FCount;
   property OriginWidth:integer read W write SetOriginWidth;
   property OriginHeight:integer read H write SetOriginHeight;
  end;

 rec=record
  x1,y1,x2,y2,ip,xni,yni,xpi,ypi:integer;
 end;

const
 MaxRecCount=100;
var
  MainForm: TMainForm;
  a: array [0..MaxRecCount] of rec;
  xindex, yindex, zindex: array[1..MaxRecCount] of integer;
  RecCount:integer;
  im:TNewImage;
implementation

{$R *.dfm}

function IndexToColor(Index:Integer):TColor;
{         Index.
         TNewImage. }
begin { IndexToColor }
 IndexToColor:=RGB(
  ((Index mod 8) shr 2) * 127 + ((Index mod 64) shr 5) * 64,
  ((Index mod 4) shr 1) * 127 + ((Index mod 32) shr 4) * 64,
  ((Index mod 2)) * 127 + ((Index mod 16) shr 3) * 64);
end; { IndexToColor }

function ColorToIndex(Color:TColor):integer;
{    Index,     .
         TNewImage,    
     . }
var
 r1,r2,g1,g2,b1,b2:byte;
procedure DcdRGB(a:byte;var a1,a2:byte);
begin
 if a>95 then a1:=1 else a1:=0;
 if ((a>31) and (a<95)) or (a>159) then a2:=1 else a2:=0;
end;
begin { ColorToIndex }
 DcdRGB(GetRValue(Color),r1,r2);
 DcdRGB(GetGValue(Color),g1,g2);
 DcdRGB(GetBValue(Color),b1,b2);
 if (r1=1) and (r2=1) and (g1=1) and (g2=1) and (b1=1) and (b2=1)
  then ColorToIndex:=1 {  - (195,195,195) }
  else ColorToIndex:=r2*32 + g2*16 + b2*8 + r1*4 + g1*2 + b1;
end; { ColorToIndex }

{ TNewImage }
constructor TNewImage.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 FMode:=1;
 FState:=0;
 FCount:=0;
 DPI:=72;
 Style1:=psSolid;
 Style2:=psSolid;
 PenWidth:=2;
 Canvas.Pen.Color:=clBlack;
 OnMouseMove:=ImageMouseMove;
 OnMouseDown:=ImageMouseDown;
 OnMouseUp:=ImageMouseUp;
 OriginBitmap:=TBitmap.Create;
 OriginBitmap.PixelFormat:=pf24bit;
 SetOriginBitmap;
end;

destructor TNewImage.Destroy;
begin
  OriginBitmap.Free;
  SetLength(Rects,0);
  inherited Destroy;
end;

procedure TNewImage.SetOriginBitmap;
begin
 if Assigned(Picture.Graphic) then
  OriginBitmap.Assign(Picture.Graphic);
 OriginBitmap.PixelFormat:=pf24bit;
 if Assigned(OriginBitmap) then
  begin
   W:=OriginBitmap.Width;
   H:=OriginBitmap.Height;
  end
 else
  begin
   W:=Width;
   H:=Height;
  end
end;

procedure TNewImage.RedrawImage;
var
 i:integer;
 n:real;
begin
 if Assigned(OriginBitmap) then
  Picture.Assign(OriginBitmap);
 n:=Width/OriginWidth;
 if 1/n>=1 then
  PenWidth:=Round(2/n)
 else
  PenWidth:=2;
 Canvas.Pen.Width:=PenWidth;
 Canvas.Pen.Mode:=pmCopy;
 Canvas.Pen.Style:=psSolid;
// Canvas.Brush.Style:= bsClear;
 Canvas.Font.Style:=[fsBold];
 Canvas.Font.Size:=12;
 for i:=1 to FCount do
  begin
   Canvas.Pen.Color:=Rects[i-1].Clr;
   DrawRect(Rects[i-1].R.Left,Rects[i-1].R.Top,
    Rects[i-1].R.Right,Rects[i-1].R.Bottom);
   if (Rects[i-1].CmtFlag) and (Rects[i-1].Cmt>'')then
    begin
     if Rects[i].sFlag
      then begin
            Canvas.Font.Color:=clHighlightText;
            Canvas.Brush.Color:=clHighlight;
           end
      else begin
            Canvas.Pen.Color:=clBlack;
            Canvas.Brush.Color:=clWindow;
           end;
     DrawText(Canvas.Handle,PChar(Rects[i-1].Cmt),Length(Rects[i-1].Cmt),
      Rects[i-1].RCmt, DT_CALCRECT or DT_VCENTER);
     Canvas.TextOut(Rects[i-1].RCmt.Left,Rects[i-1].RCmt.Top,Rects[i-1].Cmt);
    end;
  end;
 Canvas.Pen.Width:=(PenWidth-1)*2;
 Canvas.Pen.Mode:=pmXor;
 Canvas.Pen.Style:=Style1;
 Canvas.Pen.Color:=clGray;
 for i:=0 to FCount-1 do
  if Rects[i].sFlag then
   DrawRect(Rects[i].R.Left-(PenWidth-1)*2,Rects[i].R.Top-(PenWidth-1)*2,
    Rects[i].R.Right+(PenWidth-1)*2,Rects[i].R.Bottom+(PenWidth-1)*2);
end;

procedure TNewImage.DelSelected;
var
 i,n:integer;
begin
 n:=0;
 for i:=1 to FCount do
  begin
   if not Rects[i-1].sFlag then
    begin
     inc(n);
     if (i<>n) then
      Move(Rects[i-1],Rects[n-1],SizeOf(TRec));
    end;
  end;
 if FCount>n then
  begin
   FCount:=n;
   SetLength(Rects,n);
  end;
 RedrawImage;
end;

procedure TNewImage.Delete(Index:integer);
var
 i:integer;
begin
 if (Index<0) or (Index>=FCount) then exit;
 for i:=Index+1 to FCount-1 do
  begin
   Move(Rects[i],Rects[i-1],SizeOf(TRec));
  end;
 FCount:=FCount-1;
 SetLength(Rects,FCount);
 RedrawImage;
end;

procedure TNewImage.Select(Index:integer);
begin
 if (Index<0) or (Index>=FCount) then exit;
 if  not Rects[Index].sFlag then
  begin
   Rects[Index].sFlag:=true;
   Canvas.Pen.Width:=(PenWidth-1)*2;
   Canvas.Pen.Mode:=pmXor;
   Canvas.Pen.Style:=Style1;
   Canvas.Pen.Color:=clGray;
   Canvas.Font.Style:=[fsBold];
   Canvas.Font.Size:=12;
   DrawRect(Rects[Index].R.Left-(PenWidth-1)*2,Rects[Index].R.Top-(PenWidth-1)*2,
    Rects[Index].R.Right+(PenWidth-1)*2,Rects[Index].R.Bottom+(PenWidth-1)*2);
   if (Rects[Index].CmtFlag) and (Rects[Index].Cmt>'')then
    begin
     Canvas.Font.Color:=clHighlightText;
     Canvas.Brush.Color:=clHighlight;
     DrawText(Canvas.Handle,PChar(Rects[Index].Cmt),
      Length(Rects[Index].Cmt),Rects[Index].RCmt,DT_CALCRECT or DT_VCENTER);
     Canvas.TextOut(Rects[Index].RCmt.Left,Rects[Index].RCmt.Top,
      Rects[Index].Cmt);
    end;
  end;
end;

procedure TNewImage.UnSelect(Index:integer);
begin
 if (Index<0) or (Index>=FCount) then exit;
 if  Rects[Index].sFlag then
  begin
   Rects[Index].sFlag:=false;
   Canvas.Pen.Width:=(PenWidth-1)*2;
   Canvas.Pen.Mode:=pmXor;
   Canvas.Pen.Style:=Style1;
   Canvas.Pen.Color:=clGray;
   DrawRect(Rects[Index].R.Left-(PenWidth-1)*2,Rects[Index].R.Top-(PenWidth-1)*2,
    Rects[Index].R.Right+(PenWidth-1)*2,Rects[Index].R.Bottom+(PenWidth-1)*2);
   if (Rects[Index].CmtFlag) and (Rects[Index].Cmt>'')then
    begin
     Canvas.Pen.Color:=clBlack;
     Canvas.Brush.Color:=clWindow;
     DrawText(Canvas.Handle,PChar(Rects[Index].Cmt),
      Length(Rects[Index].Cmt),Rects[Index].RCmt,DT_CALCRECT or DT_VCENTER);
     Canvas.TextOut(Rects[Index].RCmt.Left,Rects[Index].RCmt.Top,
      Rects[Index].Cmt);
    end;
  end;
end;

procedure TNewImage.SetOriginWidth(Value:integer);
begin
 W:=Value;
 if Assigned(OriginBitmap) then
  OriginBitmap.Width:=Value;
end;

procedure TNewImage.SetOriginHeight(Value:integer);
begin
 H:=Value;
 if Assigned(OriginBitmap) then
  OriginBitmap.Height:=Value;
end;

procedure TNewImage.DrawRect(X1,Y1,X2,Y2:integer);
begin
 Canvas.MoveTo(X1,Y1);
 Canvas.LineTo(X2,Y1);
 Canvas.LineTo(X2,Y2);
 Canvas.LineTo(X1,Y2);
 Canvas.LineTo(X1,Y1);
end;

procedure TNewImage.ImageMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
 i,k,n,m:integer;
 f:boolean;
procedure SetSel(Index:integer; SelFlag:boolean);
begin
 Rects[Index].sFlag:=SelFlag;
 DrawRect(Rects[Index].R.Left-(PenWidth-1)*2,Rects[Index].R.Top-(PenWidth-1)*2,
  Rects[Index].R.Right+(PenWidth-1)*2,Rects[Index].R.Bottom+(PenWidth-1)*2);
end;
begin
 if Stretch then
  begin
   X:=Round(X*W/Width);
   Y:=Round(Y*H/Height);
  end;
 if FState=0 then
  if FMode=0 then
   begin
    Canvas.Pen.Width:=(PenWidth-1)*2;
    Canvas.Pen.Mode:=pmXor;
    Canvas.Pen.Style:=Style1;
    Canvas.Pen.Color:=clGray;
    n:=-1; m:=-1; k:=-1;
    for i:=0 to FCount-1 do
     if (X>=Rects[i].R.Left) and (X<=Rects[i].R.Right) and
      (Y>=Rects[i].R.Top) and (Y<=Rects[i].R.Bottom)
      then
      if Rects[i].sFlag then
       begin
        n:=i; break;
       end
      else
       begin
        k:=i;
       end;
    if n>=0 then
    for i:=n+1 to FCount-1 do
     if (X>=Rects[i].R.Left) and (X<=Rects[i].R.Right) and
      (Y>=Rects[i].R.Top) and (Y<=Rects[i].R.Bottom) then
      if not Rects[i].sFlag then
       begin
        m:=i; break;
       end;
    for i:=0 to FCount-1 do
     begin
      f:=(X>=Rects[i].R.Left) and (X<=Rects[i].R.Right) and
       (Y>=Rects[i].R.Top) and (Y<=Rects[i].R.Bottom);
      if f then
       if (m>=0) then
        if (i=m) then SetSel(i,true)
        else
         if Rects[i].sFlag then SetSel(i,false)
         else
       else
        if (k<0) and (n>=0) and (i<>n) then
         if Rects[i].sFlag then SetSel(i,false)
         else
        else
         if not Rects[i].sFlag then SetSel(i,true)
       else
      else
       if Rects[i].sFlag then SetSel(i,false)
     end;
   end
  else
   begin
    FState:=1;
    X0:=X;
    Y0:=Y;
    X1:=X;
    Y1:=Y;
    Canvas.Pen.Width:=PenWidth-1;
    Canvas.Pen.Mode:=pmXor;
    Canvas.Pen.Style:=Style2;
    Canvas.Pen.Color:=clGray;
    DrawRect(X0-1,Y0-1,X1+1,Y1+1);
   end;
 with Sender as TImage do
  if Screen.ActiveControl<>(Parent as TWinControl) then
   with Parent as TWinControl do begin if CanFocus then SetFocus end;
end;

procedure TNewImage.ImageMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
 if Stretch then
  begin
   X:=Round(X*W/Width);
   Y:=Round(Y*H/Height);
  end;
 if FMode=1 then
  if FState=1 then
   if (abs(X-X1)>4) or (abs(Y-Y1)>4) then
   begin
    Canvas.Pen.Width:=PenWidth-1;
    Canvas.Pen.Mode:=pmXor;
    Canvas.Pen.Style:=Style2;
    Canvas.Pen.Color:=clGray;
    DrawRect(X0-1,Y0-1,X1+1,Y1+1);
    X1:=X;
    Y1:=Y;
    DrawRect(X0-1,Y0-1,X1+1,Y1+1);
   end;
end;

procedure TNewImage.ImageMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
 i, xx, yy:integer;
begin
 if Stretch then
  begin
   X:=Round(X*W/Width);
   Y:=Round(Y*H/Height);
  end;
 if FMode=1 then
  if FState=1 then
   begin
    FState:=0;
    Canvas.Pen.Width:=PenWidth-1;
    Canvas.Pen.Mode:=pmXor;
    Canvas.Pen.Style:=Style2;
    Canvas.Pen.Color:=clGray;
    DrawRect(X0-1,Y0-1,X1+1,Y1+1);
    X1:=X;
    Y1:=Y;
    if (X0<>X1) or (Y0<>Y1) then
     begin
      Inc(FCount);
      SetLength(Rects,FCount);
      Rects[FCount-1].sFlag:=false;
      Rects[FCount-1].Dat:=Now;
      Rects[FCount-1].Cmt:='';
      Rects[FCount-1].Id:=0;
      if (x0>x1) or (y0>y1) then
       begin
        xx:=x0; yy:=y0;
        x0:=x1; y0:=y1;
        x1:=xx; y1:=yy;
       end;
      Rects[FCount-1].R:=Rect(X0,Y0,X1,Y1);
      if FCount<=1 then i:=1 else i:=ColorToIndex(Rects[FCount-2].Clr)+1;
      Rects[FCount-1].Clr:=IndexToColor(i);
      Canvas.Pen.Width:=PenWidth;
      Canvas.Pen.Mode:=pmCopy;
      Canvas.Pen.Style:=psSolid;
      Canvas.Pen.Color:=Rects[FCount-1].Clr;
      DrawRect(Rects[FCount-1].R.Left,Rects[FCount-1].R.Top,
       Rects[FCount-1].R.Right,Rects[FCount-1].R.Bottom);
     end;
   end;
end;

function Per(i,x1,y1,x2,y2:integer):boolean;
begin
 if i=0 then Result:=false
 else
 Result:=(a[i].x1<=x2) and
   (a[i].x2>=x1) and
   (a[i].y1<=y2) and
   (a[i].y2>=y1);
end;

function Rasst(x1,y1,x2,y2:double):double;
begin
 Result:=Sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
end;

procedure GetNewCoord(si,maxx,maxy:integer);
var
 x1,x2,y1,y2,rx1,ry1,rx2,ry2,i,j,
 ssx,ssy, msi,mo:integer;
 cx,cy:integer;
 MinR:real;

procedure Next(i, mode:integer; rold:double; x1,y1,x2,y2:integer);
var
 dx,dy,j,ip:integer;
 f:boolean;
 r:double;
begin
 r:=0;
 case mode of
1: begin
    dx:=x2-x1;
    x1:=a[i].x1-dx-1;
    x2:=a[i].x1-1;
    if x1<0 then exit;
    r:=Rasst(cx,cy,(x1+x2) div 2,(y1-y2) div 2);
    if r<=rold then exit;

{    if not Per(a[i].xpi,x1,y1,x2,y2) then
     begin
      if r<MinR then
       begin
        MinR:=r;
        rx1:=x1; rx2:=x2; ry1:=y1; ry2:=y2;
        msi:=i;
        mo:=mode;
       end;
      exit;
     end
    else
     i:=a[i].xpi;}
   end;
2: begin
    dx:=x2-x1;
    x1:=a[i].x2+1;
    x2:=x1+dx+1;
    if x2>maxx then exit;
    r:=Rasst(cx,cy,(x1+x2) div 2,(y1-y2) div 2);
    if r<=rold then exit;
{    if not Per(a[i].xni,x1,y1,x2,y2) then
     begin
      if r<MinR then
       begin
        MinR:=r;
        rx1:=x1; rx2:=x2; ry1:=y1; ry2:=y2;
        msi:=i;
        mo:=mode;
       end;
      exit;
     end
    else
     i:=a[i].xni;}
   end;
3: begin
    dy:=y2-y1;
    y1:=a[i].y1-dy-1;
    y2:=a[i].y1-1;
    if y1<0 then exit;
    r:=Rasst(cx,cy,(x1+x2) div 2,(y1-y2) div 2);
    if r<=rold then exit;
{    if not Per(a[i].ypi,x1,y1,x2,y2) then
     begin
      if r<MinR then
       begin
        MinR:=r;
        rx1:=x1; rx2:=x2; ry1:=y1; ry2:=y2;
        msi:=i;
        mo:=mode;
       end;
      exit;
     end
    else
     i:=a[i].ypi;}
   end;
4: begin
    dy:=y2-y1;
    y1:=a[i].y2+1;
    y2:=y1+dy+1;
    if y2>maxy then exit;
    r:=Rasst(cx,cy,(x1+x2) div 2,(y1-y2) div 2);
    if r<=rold then exit;
{    if not Per(a[i].ypi,x1,y1,x2,y2) then
     begin
      if r<MinR then
       begin
        MinR:=r;
        rx1:=x1; rx2:=x2; ry1:=y1; ry2:=y2;
        msi:=i;
        mo:=mode;
       end;
      exit;
     end
    else
     i:=a[i].yni;  }
   end;
 end;
 if mode>0 then
  begin
   f:=false;
   for j:=1 to RecCount do
    if (j<>i) and (j<>si) then
     begin
      f:=f or Per(j,x1,y1,x2,y2);
      if f then begin ip:=j; break; end;
     end;
   if not f then
     begin
      if r<MinR then
       begin
        MinR:=r;
        rx1:=x1; rx2:=x2; ry1:=y1; ry2:=y2;
        msi:=i;
        mo:=mode;
       end;
      exit;
     end
    else
     i:=ip;
  end;
 if ssx<=0 then Next(i, 1, r, x1,y1,x2,y2);
 if ssx>=0 then Next(i, 2, r, x1,y1,x2,y2);
 if ssy<=0 then Next(i, 3, r, x1,y1,x2,y2);
 if ssy>=0 then Next(i, 4, r, x1,y1,x2,y2);
end;
begin
 x1:=a[si].x1;
 x2:=a[si].x2;
 y1:=a[si].y1;
 y2:=a[si].y2;
 cx:=(a[si].x1+a[si].x2) div 2;
 cy:=(a[si].y1+a[si].y2) div 2;
{ ssx:=cx-(a[a[si].ip].x1+a[a[si].ip].x2) div 2;
 ssy:=cy-(a[a[si].ip].y1+a[a[si].ip].y2) div 2;}
 ssx:=a[si].x1-a[a[si].ip].x1;
 ssy:=a[si].y1-a[a[si].ip].y1;
 rx1:=-1; rx2:=-1; ry1:=-1; ry2:=-1;
 MinR:=MaxInt;
 mo:=0;
 Next(a[si].ip, 0, 0, x1, y1, x2, y2);
 if mo>0 then
  begin
  a[si].x1:=rx1;
  a[si].x2:=rx2;
  a[si].y1:=ry1;
  a[si].y2:=ry2;
  a[si].ip:=0;
  end
 else
  begin
   ssx:=0;
   ssy:=0;
   Next(a[si].ip, 0, 0, x1, y1, x2, y2);
 if mo>0 then
  begin
  a[si].x1:=rx1;
  a[si].x2:=rx2;
  a[si].y1:=ry1;
  a[si].y2:=ry2;
  a[si].ip:=0;
  end
 else
   a[si].ip:=0;
  end;

{ case mo of
  1: begin
      a[a[msi].xpi].xni:=si;
      a[msi].xpi:=si;
     end;
  2: begin
      a[a[msi].xni].xpi:=si;
      a[msi].xni:=si;
     end;
  3: begin
      a[a[msi].ypi].yni:=si;
      a[msi].ypi:=si;
     end;
  4: begin
      a[a[msi].yni].ypi:=si;
      a[msi].yni:=si;
     end;
 end;
 i:=si;
 if mo>0 then
 for j:=1 to RecCount do
  if i<>j then
   if a[j].ip=0 then
    begin
     if (a[i].x1<=a[j].x2) and
     (a[i].x2>=a[j].x1) then
     begin
      if yindex[j]<yindex[i] then
       if a[i].ypi=0 then a[i].ypi:=j else
        if yindex[j]>yindex[a[i].ypi] then a[i].ypi:=j;
      if yindex[j]>yindex[i] then
       if a[i].yni=0 then a[i].yni:=j else
        if yindex[j]<yindex[a[i].yni] then a[i].yni:=j;
     end;
     if (a[i].y1<=a[j].y2) and
     (a[i].y2>=a[j].y1) then
     begin
      if xindex[j]<xindex[i] then
       if a[i].xpi=0 then a[i].xpi:=j else
       if xindex[j]>xindex[a[i].xpi] then a[i].xpi:=j;
      if xindex[j]>xindex[i] then
       if a[i].xni=0 then a[i].xni:=j else
        if xindex[j]<xindex[a[i].xni] then a[i].xni:=j;
     end;
    end;}

 end;


procedure TMainForm.MyButtonClick(Sender: TObject);
var
 i,j,k:integer;
 f:boolean;
begin
 if im.Count<=1 then exit;
 RecCount:=im.Count;
 for i:=0 to RecCount-1 do
  begin
   a[i+1].x1:=im.Rects[i].R.Left;
   a[i+1].y1:=im.Rects[i].R.Top;
   a[i+1].x2:=im.Rects[i].R.Right;
   a[i+1].y2:=im.Rects[i].R.Bottom;
  end;
 i:=0;
 while i<RecCount do
  begin
   inc(i);
   xindex[i]:=i;
   yindex[i]:=i;
   j:=i-1;
   while (j>=1) and ((a[xindex[j]].x1+a[xindex[j]].x2) div 2>(a[xindex[i]].x1+a[xindex[i]].x2) div 2) do
    begin
     k:=xindex[j];
     xindex[j]:=xindex[i];
     xindex[i]:=k;
     dec(j);
    end;
   j:=i-1;
   while (j>=1) and ((a[yindex[j]].y1+a[yindex[j]].y2) div 2>(a[yindex[i]].y1+a[yindex[i]].y2) div 2) do
    begin
     k:=yindex[j];
     yindex[j]:=yindex[i];
     yindex[i]:=k;
     dec(j);
    end;
   j:=1;
   a[i].ip:=0;
   f:=false;
   while j<i do
    begin
     f:=f or Per(i,a[j].x1,a[j].y1,a[j].x2,a[j].y2);
     if f then begin a[i].ip:=j; break; end;
     inc(j);
    end;
  end;

{  for i:=1 to RecCount do
   begin
    if a[i].ip=0 then
    for j:=1 to RecCount do
     if i<>j then
      if a[j].ip=0 then
      begin
       if (a[i].x1<=a[j].x2) and
        (a[i].x2>=a[j].x1) then
        begin
         if yindex[j]<yindex[i] then
          if a[i].ypi=0 then a[i].ypi:=j else
           if yindex[j]>yindex[a[i].ypi] then a[i].ypi:=j;
         if yindex[j]>yindex[i] then
          if a[i].yni=0 then a[i].yni:=j else
           if yindex[j]<yindex[a[i].yni] then a[i].yni:=j;
        end;
       if (a[i].y1<=a[j].y2) and
        (a[i].y2>=a[j].y1) then
        begin
         if xindex[j]<xindex[i] then
          if a[i].xpi=0 then a[i].xpi:=j else
           if xindex[j]>xindex[a[i].xpi] then a[i].xpi:=j;
         if xindex[j]>xindex[i] then
          if a[i].xni=0 then a[i].xni:=j else
           if xindex[j]<xindex[a[i].xni] then a[i].xni:=j;
        end;
      end;
   end;}
 for i:=1 to RecCount do
  begin
   if a[i].ip>0 then
    GetNewCoord(i,im.Width,im.Height);
  end;
 for i:=0 to RecCount-1 do
  begin
   im.Rects[i].R.Left:=a[i+1].x1;
   im.Rects[i].R.Top:=a[i+1].y1;
   im.Rects[i].R.Right:=a[i+1].x2;
   im.Rects[i].R.Bottom:=a[i+1].y2;
  end;
 im.RedrawImage;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
 im:=TNewImage.Create(MainForm);
 im.Parent:=MainForm;
 im.Left:=50; im.Top:=50;
 im.Width:=600; im.Height:=600;
 im.OriginBitmap.Width:=im.Width;
 im.OriginBitmap.Height:=im.Height;
 im.Picture.Bitmap.Width:=im.Width;
 im.Picture.Bitmap.Height:=im.Height;
 im.SetOriginWidth(im.Width);
 im.SetOriginHeight(im.Height);
 im.Stretch:=true;
end;

end.
