unit phunit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Grids, ExtCtrls, Menus, ImgList, ToolWin, StdCtrls, Inifiles;

type
  TMAINForm = class(TForm)
    MainMenu: TMainMenu;
    FileMenu: TMenuItem;
    FMOpen: TMenuItem;
    FMSep1: TMenuItem;
    FMExit: TMenuItem;
    FMSave: TMenuItem;
    FMSep2: TMenuItem;
    MainPanel: TPanel;
    MainStringGrid: TStringGrid;
    MainHeaderControl: THeaderControl;
    PhoneOpenDialog: TOpenDialog;
    MainToolBar: TToolBar;
    FileOpenToolButton: TToolButton;
    FileSaveToolButton: TToolButton;
    Sep1ToolButton: TToolButton;
    AddRecToolButton: TToolButton;
    EditRecToolButton: TToolButton;
    DelRecToolButton: TToolButton;
    MainImageList: TImageList;
    FNameLabel: TLabel;
    FWorkPhoneLabel: TLabel;
    EditMenu: TMenuItem;
    EMAddRec: TMenuItem;
    EMEditRec: TMenuItem;
    EMDelRec: TMenuItem;
    PhoneSaveDialog: TSaveDialog;
    HelpMenu: TMenuItem;
    HMAbout: TMenuItem;
    FHomePhoneLabel: TLabel;
    TopPanel: TPanel;
    FindLabel: TLabel;
    FindEdit: TEdit;
    procedure FMOpenClick(Sender: TObject);
    procedure MainHeaderControlSectionResize(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure FormCreate(Sender: TObject);
    procedure AddRecToolButtonClick(Sender: TObject);
    procedure EditRecToolButtonClick(Sender: TObject);
    procedure DelRecToolButtonClick(Sender: TObject);
    procedure MainHeaderControlSectionClick(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure FindEditChange(Sender: TObject);
    procedure MainStringGridSelectCell(Sender: TObject; ACol,
      ARow: Integer; var CanSelect: Boolean);
    procedure FMSaveClick(Sender: TObject);
    procedure HMAboutClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FMExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    procedure OpenFile;
    procedure SaveFile;
    procedure SetBook;
    procedure MenuEnabled;
    { Public declarations }
  end;

 TPhoneBook=record
  Name: String[50];
  HomePhone: String[7];
  WorkPhone: String[7];
  Address: String[11];
 end;

var
  MAINForm: TMAINForm;
  MainRec: array of TPhoneBook;
  F: TFileStream;
  MainIniFile: TIniFile;
  RecCount:integer=0;
  PhoneFileName:string='';
  SortMode:integer=0;
  ChangeFlag: boolean=false;
const
  MainIniFileName='phbook.ini';

implementation

uses phedit, qunit, abunit, sunit;

{$R *.dfm}

procedure SortBook(Mode: byte);
var
 i,j:integer;
 rec:TPhoneBook;
begin
 case Mode of
  0: begin
      i:=1;
      while i<RecCount do
       begin
        j:=0;
        while (j<i) do
         if (AnsiUpperCase(MainRec[i].Name)<AnsiUpperCase(MainRec[j].Name)) then
         begin
          rec:=MainRec[i];
          MainRec[i]:=MainRec[j];
          MainRec[j]:=rec;
          j:=j+1;
         end
         else j:=j+1;
        i:=i+1;
       end;
     end;
  1: begin
      i:=1;
      while i<RecCount do
       begin
        j:=0;
        while (j<i) do
         if AnsiUpperCase(MainRec[i].WorkPhone)<AnsiUpperCase(MainRec[j].WorkPhone) then
         begin
          rec:=MainRec[i];
          MainRec[i]:=MainRec[j];
          MainRec[j]:=rec;
          j:=j+1;
         end
         else j:=j+1;
        i:=i+1;
       end;
     end;
  2: begin
      i:=1;
      while i<RecCount do
       begin
        j:=0;
        while (j<i) do
         if AnsiUpperCase(MainRec[i].HomePhone)<AnsiUpperCase(MainRec[j].HomePhone) then
         begin
          rec:=MainRec[i];
          MainRec[i]:=MainRec[j];
          MainRec[j]:=rec;
          j:=j+1;
         end
         else j:=j+1;
        i:=i+1;
       end;
     end;
 end;
end;

procedure TMainForm.OpenFile;
var
 i:integer;
begin
 F:=TFileStream.Create(PhoneFileName,fmOpenReadWrite or fmShareExclusive); // 
 RecCount:=F.Size div SizeOf(TPhoneBook);
 SetLength(MainRec,RecCount);
 for i:=0 to RecCount-1 do
  F.Read(MainRec[i],SizeOf(TPhoneBook));
 F.Free;
end;

procedure TMainForm.SetBook;
var
 i:integer;
begin
 with MainStringGrid do
  begin
   Cols[0].Clear;
   Cols[1].Clear;
   Cols[2].Clear;
   Cols[3].Clear;
   RowCount:=RecCount;
  end;
 SortBook(SortMode);
 for i:=0 to RecCount-1 do
  with MainStringGrid do
   begin
    Cells[0,i]:=MainRec[i].Name;
    Cells[1,i]:=MainRec[i].WorkPhone;
    Cells[2,i]:=MainRec[i].HomePhone;
    Cells[3,i]:=' '+MainRec[i].Address;
   end;
 with MainStringGrid do
  begin
   FNameLabel.Caption:=Cells[0, Row];
   FWorkPhoneLabel.Caption:=Cells[1, Row];
   FHomePhoneLabel.Caption:=Cells[2, Row];
  end;
end;

procedure TMainForm.MenuEnabled;
begin
 EditRecToolButton.Enabled:=RecCount>0;
 DelRecToolButton.Enabled:=RecCount>0;
end;

procedure TMAINForm.FMOpenClick(Sender: TObject);
begin
 If ChangeFlag then
  begin
   SaveForm.ShowModal;
   if BtnFlg=0 then
    begin
     if PhoneFileName='' then
      if PhoneSaveDialog.Execute then
       begin
        PhoneFileName:=PhoneSaveDialog.FileName;
        SaveFile;
       end
      else
     else
      SaveFile;
    end;
  end;
 If PhoneOpenDialog.Execute Then
  begin
   PhoneFileName:=PhoneOpenDialog.FileName;
   OpenFile;
   MainStringGrid.Row:=0;
   SetBook;
   MenuEnabled;
  end;
end;

procedure TMAINForm.MainHeaderControlSectionResize(
  HeaderControl: THeaderControl; Section: THeaderSection);
begin
 MainStringGrid.ColWidths[Section.Index]:=Section.Width-2;
end;

procedure TMAINForm.FormCreate(Sender: TObject);
begin
 MainStringGrid.ColWidths[0]:=MainHeaderControl.Sections[0].Width-2;
 MainStringGrid.ColWidths[1]:=MainHeaderControl.Sections[1].Width-2;
 MainStringGrid.ColWidths[2]:=MainHeaderControl.Sections[2].Width-2;
 MainStringGrid.ColWidths[3]:=MainHeaderControl.Sections[3].Width-2;
 MainIniFile:=TIniFile.Create(MainIniFileName);
 with MainIniFile do
  begin
   PhoneFileName:=ReadString('General','PhoneBaseFile','');
   Free;
  end;
 if PhoneFileName<>'' then
  begin
   OpenFile;
   MainStringGrid.Row:=0;
   SetBook;
   MenuEnabled;
  end
 else MenuEnabled;
end;

procedure TMAINForm.AddRecToolButtonClick(Sender: TObject);
var
 i:integer;
begin
 with PhoneNumberForm do
  begin
   NameEdit.Text:='';
   WorkPhoneEdit.Text:='';
   HomePhoneEdit.Text:='';
   AddressEdit.Text:='';
   ShowModal;
   if OkBtnFlg then
    begin
     RecCount:=RecCount+1;
     SetLength(MainRec,RecCount);
     MainRec[RecCount-1].Name:=Trim(NameEdit.Text);
     MainRec[RecCount-1].HomePhone:=Trim(HomePhoneEdit.Text);
     MainRec[RecCount-1].WorkPhone:=Trim(WorkPhoneEdit.Text);
     MainRec[RecCount-1].Address:=Trim(AddressEdit.Text);
     SortBook(SortMode);
     SetBook;
     with MainStringGrid do
     for i:=0 to RowCount-1 do
      if Cells[0,i]=Trim(NameEdit.Text) then
       begin
        Row:=i;
        break;
       end;
     ChangeFlag:=true;
    end;
 MenuEnabled;
end;

end;

procedure TMAINForm.EditRecToolButtonClick(Sender: TObject);
var
 i:integer;
begin
 if RecCount>0 then
 with PhoneNumberForm do
  begin
   NameEdit.Text:=MainStringGrid.Cells[0,MainStringGrid.Row];
   WorkPhoneEdit.Text:=MainStringGrid.Cells[1,MainStringGrid.Row];
   HomePhoneEdit.Text:=MainStringGrid.Cells[2,MainStringGrid.Row];
   AddressEdit.Text:=Trim(MainStringGrid.Cells[3,MainStringGrid.Row]);
   ShowModal;
   if OkBtnFlg then
    begin
     MainRec[MainStringGrid.Row].Name:=Trim(NameEdit.Text);
     MainRec[MainStringGrid.Row].HomePhone:=Trim(HomePhoneEdit.Text);
     MainRec[MainStringGrid.Row].WorkPhone:=Trim(WorkPhoneEdit.Text);
     MainRec[MainStringGrid.Row].Address:=Trim(AddressEdit.Text);
     SortBook(SortMode);
     SetBook;
     with MainStringGrid do
     for i:=0 to RowCount-1 do
      if Cells[0,i]=Trim(NameEdit.Text) then
       begin
        Row:=i;
        break;
       end;
     ChangeFlag:=true;
    end;
  end;
end;

procedure TMAINForm.DelRecToolButtonClick(Sender: TObject);
var
 i:integer;
begin
 QForm.ShowModal;
 if YesBtnFlg then
  begin
   for i:=MainStringGrid.Row+1 to RecCount-1 do
    MainRec[i-1]:=MainRec[i];
   RecCount:=RecCount-1;
   SetLength(MainRec,RecCount);
   SetBook;
   ChangeFlag:=true;
  end;
 MenuEnabled;
end;

procedure TMAINForm.MainHeaderControlSectionClick(
  HeaderControl: THeaderControl; Section: THeaderSection);
begin
 SortMode:=Section.Index;
 SortBook(SortMode);
 SetBook;
end;

procedure TMAINForm.FindEditChange(Sender: TObject);
var
 i,j, m:integer;
 s,s1,s2:string;
 f:boolean;
begin
 f:=false;
 s:=AnsiUpperCase(FindEdit.Text);
 for m:=0 to 2 do
  begin
   if f then break;
   for i:=0 to RecCount-1 do
    case m of
     0: if AnsiUpperCase(Copy(MainRec[i].Name,1,Length(s)))=s then
         begin
          MainStringGrid.Row:=i;
          f:=true;
          break;
         end;
     1: if AnsiUpperCase(Copy(MainRec[i].WorkPhone,1,Length(s)))=s then
         begin
          MainStringGrid.Row:=i;
          f:=true;
          break;
         end
        else
         begin
          s1:=''; s2:=MainRec[i].WorkPhone;
          for j:=1 to length(s2) do
           if s2[j] in ['0'..'9'] then s1:=s1+s2[j];
          if AnsiUpperCase(Copy(s1,1,Length(s)))=s then
           begin
            MainStringGrid.Row:=i;
            f:=true;
            break;
           end
         end;
     2: if AnsiUpperCase(Copy(MainRec[i].HomePhone,1,Length(s)))=s then
         begin
          MainStringGrid.Row:=i;
          f:=true;
          break;
         end
        else
         begin
          s1:=''; s2:=MainRec[i].HomePhone;
          for j:=1 to length(s2) do
           if s2[j] in ['0'..'9'] then s1:=s1+s2[j];
          if AnsiUpperCase(Copy(s1,1,Length(s)))=s then
           begin
            MainStringGrid.Row:=i;
            f:=true;
            break;
           end
         end;
    end;
  end;
end;

procedure TMAINForm.MainStringGridSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
 if MainStringGrid.Row<>ARow then
  begin
   FNameLabel.Caption:=MainStringGrid.Cells[0, ARow];
   FWorkPhoneLabel.Caption:=MainStringGrid.Cells[1, ARow];
   FHomePhoneLabel.Caption:=MainStringGrid.Cells[2, ARow];
  end;
end;

procedure TMainForm.SaveFile;
var
 i:integer;
begin
 ChangeFlag:=false;
 F:=TFileStream.Create(PhoneFileName,fmCreate or fmShareExclusive); // 
 for i:=0 to RecCount-1 do
  F.Write(MainRec[i],SizeOf(TPhoneBook));
 F.Free;
end;

procedure TMAINForm.FMSaveClick(Sender: TObject);
begin
 if PhoneFileName='' then
  if PhoneSaveDialog.Execute then
   begin
    PhoneFileName:=PhoneSaveDialog.FileName;
    SaveFile;
   end
  else
 else
  SaveFile;
end;

procedure TMAINForm.HMAboutClick(Sender: TObject);
begin
 AboutForm.ShowModal;
end;

procedure TMAINForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 If ChangeFlag then
  begin
   SaveForm.ShowModal;
   if BtnFlg=0 then
    begin
     if PhoneFileName='' then
      if PhoneSaveDialog.Execute then
       begin
        PhoneFileName:=PhoneSaveDialog.FileName;
        SaveFile;
       end
      else
     else
      SaveFile;
    end;
   if BtnFlg=2 then Action:=caNone;
  end;
 MainIniFile:=TIniFile.Create(MainIniFileName);
 with MainIniFile do
  begin
   WriteString('General','PhoneBaseFile',PhoneFileName);
   Free;
  end;
end;

procedure TMAINForm.FMExitClick(Sender: TObject);
begin
 Close;
end;

end.
