unit rotate2u;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Label1: TLabel;
    procedure FormPaint(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
   procedure Line(x1,y1,x2,y2:integer);
   procedure Figures
        (NFig, {  :
                 0 - ;
                 1 - ;
                 2 - ;
                 3  4 -  ;
                 5 - ;
                 6 - ; }
         NVerge, {      }
         x0,y0, {     }
         h, {   }
         dx, {     x }
         dy:Word; {   }
         Angle:Integer {    -  0  360 });
  end;

var
  Form1: TForm1;
  NFigure,Angle:integer;

implementation

{$R *.dfm}

procedure TForm1.Line(x1,y1,x2,y2:integer);
begin
 Canvas.MoveTo(x1,y1);
 Canvas.LineTo(x2,y2);
end;

procedure TForm1.Figures
        (NFig, {  :
                 0 - ;
                 1 - ;
                 2 - ;
                 3  4 -  ;
                 5 - ;
                 6 - ; }
         NVerge, {      }
         x0,y0, {     }
         h, {   }
         dx, {     x }
         dy:Word; {   }
         Angle:Integer {    -  0  360 });
var
 i:Integer;
 x,y,x_,y_:Integer;
 x1,y1,x1_,y1_:Integer;
 a:Real;
 a1:Real;
begin
 if NFig>6 then Exit;
 if NFig=5 then NVerge:=5;
 if NFig=6 then NVerge:=6;
 y0:=y0-h div 2; x:=0; y:=0; x1:=0; y1:=0;
 for i:=0 to NVerge do
  begin
   if NFig<5 then
    begin
     a:=2*pi*(i/NVerge+Angle/360);
     x_:=x; y_:=y;
     x:=Trunc(dx*Cos(a)/2)+x0;
     y:=Trunc(dy*Sin(a)/2)+y0;
     if i>0 then
      case NFig of
       0: begin
           Line(x,y,x_,y_);
           Line(x,y+h,x_,y_+h);
           Line(x,y,x,y+h);
          end;
       1: begin
           Line(x,y+h,x_,y_+h);
           Line(x0,y0,x,y+h)
          end;
       2: begin
           Line(x,y+h div 2,x_,y_+h div 2);
           Line(x0,y0,x,y+h div 2);
           Line(x0,y0+h,x,y+h div 2);
          end;
       3: begin
           Line(x,y+h div 2,x_,y_+h div 2);
           Line((x-x0) div 2+x0,y,(x_-x0) div 2+x0,y_);
           Line((x-x0) div 2+x0,y+h,(x_-x0) div 2+x0,y_+h);
           Line((x-x0) div 2+x0,y,x,y+h div 2);
           Line((x-x0) div 2+x0,y+h,x,y+h div 2);
          end;
       4: begin
           Line(x,y+h div 3,x_,y_+h div 3);
           Line(x,y+2*h div 3,x_,y_+2*h div 3);
           Line((x-x0) div 2+x0,y,(x_-x0) div 2+x0,y_);
           Line((x-x0) div 2+x0,y+h,(x_-x0) div 2+x0,y_+h);
           Line((x-x0) div 2+x0,y,x,y+h div 3);
           Line((x-x0) div 2+x0,y+h,x,y+2*h div 3);
           Line(x,y+h div 3,x,y+2*h div 3);
          end;
      end;
    end
   else
    begin
     a:=2*pi*(i/NVerge+Angle/360);
     x_:=x; y_:=y;
     x:=Trunc(dx*Cos(a)/2)+x0;
     y:=Trunc(dy*Sin(a)/2)+y0;
     a1:=2*pi*((2*i+1)/(2*NVerge)+Angle/360);
     x1_:=x1; y1_:=y1;
     x1:=Trunc(dx*Cos(a1)/2)+x0;
     y1:=Trunc(dy*Sin(a1)/2)+y0+h;
     if i>0 then
      case NFig of
       5: begin
           Line(x,y,x_,y_);
           Line(x1,y1,x1_,y1_);
           Line(x,y,(x-x0)*9 div 5+x0,y+2*h div 5);
           Line(x1,y1,(x1-x0)*9 div 5+x0,y1-2*h div 5);
           Line((x-x0)*9 div 5+x0,y+2*h div 5,(x1-x0)*9 div 5+x0,y1-2*h div 5);
           Line((x-x0)*9 div 5+x0,y+2*h div 5,(x1_-x0)*9 div 5+x0,y1_-2*h div 5);
          end;
       6: begin
           Line(x,y+h div 4,x_,y_+h div 4);
           Line(x1,y1-h div 4,x1_,y1_-h div 4);
           Line(x0,y0,x,y+h div 4);
           Line(x0,y0+h,x1,y1-h div 4);
           Line(x,y+h div 4,x1,y1-h div 4);
           Line(x,y+h div 4,x1_,y1_-h div 4);
          end;
       end;
    end;
  end;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
 Figures(NFigure,4,320,240,200,200,60,Angle);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
 Angle:=(Angle+1) mod 360;
 Repaint;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
 if Key=#32 then NFigure:=(NFigure+1) mod 7;
end;

end.
