unit CFUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, inifiles, ExtCtrls, ShellApi, AniImg, ImgList;

type
  TCopyFileForm = class(TForm)
    InFileNameEdit: TEdit;
    InFileNameLabel: TLabel;
    LoadButton: TButton;
    StopButton: TButton;
    CopyProgressBar: TProgressBar;
    CopySizeLabel: TLabel;
    CSLabel: TLabel;
    TimeLabel: TLabel;
    TimeRemainLabel: TLabel;
    TLabel: TLabel;
    TRLabel: TLabel;
    FileSaveDialog: TSaveDialog;
    FileOpenDialog: TOpenDialog;
    MainTimer: TTimer;
    TotalSizeLabel: TLabel;
    TSLabel: TLabel;
    IPLabel: TLabel;
    IPEdit: TEdit;
    SpeedLabel: TLabel;
    SLabel: TLabel;
    OutFileNameLabel: TLabel;
    OutFileNameEdit: TEdit;
    MainImageList: TImageList;
    procedure FormCreate(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure MenuEnabled;
    procedure ShowProgressBar;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MainTimerTimer(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure InFileNameEditDblClick(Sender: TObject);
    procedure InFileNameEditChange(Sender: TObject);
    procedure OutFileNameEditDblClick(Sender: TObject);
    procedure OutFileNameEditChange(Sender: TObject);
  private
    MAnimatedImage:TAnimateImage;
   procedure WMDropFiles(var msg : TMessage); message WM_DROPFILES;    { Public declarations }
    { Private declarations }
  public
  end;
const
 SizeBuf=262144;
var
  CopyFileForm: TCopyFileForm;
  MainIniFile:TIniFile;
  LastInFileName,LastOutFileName:string;
  InFileSize, OutFileSize: integer;
  StartFlag:boolean;
  buf:array[0..SizeBuf-1] of byte;
  SizeC,sc1:integer;
  StartTime,st1:TDateTime;
  ac:real;
const
 MainIniName='copyfile.ini';
 editFlag:boolean=false;
 sb:integer=32768;

implementation

{$R *.DFM}

procedure TCopyFileForm.WMDropFiles(var Msg:TMessage);
var
 Size:Word;
 FName:String;
 HDrop:Integer;
begin
 HDrop:=Msg.WParam;
 Size:=DragQueryFile(HDrop, 0, nil, 0);
 SetLength(FName,Size);
 DragQueryFile(HDrop, 0, @FName[1], Size + 1);
 InFileNameEdit.Text:=FName;
 LastInFileName:=InFileNameEdit.Text;
 LastOutFileName:=ExtractFileName(LastInFileName);
 OutFileNameEdit.Text:=LastOutFileName;
 Msg.Result := 0;
 inherited;
end;

procedure TCopyFileForm.ShowProgressBar;
var
 a1,a2:real;
 s:string;
begin
 CSLabel.Caption:=IntToStr(OutFileSize);
 a1:=InFileSize; a2:=OutFileSize;
 if a1=0 then
  begin
   CopyProgressBar.Position:=100;
   s:='100.00';
  end
 else
  begin
   CopyProgressBar.Position:=Round(100*a2/a1);
   s:=Format('%3.2f',[100*a2/a1]);
  end;
 Application.Title:=' ('+s+'%)';
end;

procedure TCopyFileForm.MenuEnabled;
begin
 if StartFlag then
  begin
   MAnimatedImage.Visible:=true;
   MAnimatedImage.Active:=true;
   IPEdit.Enabled:=false;
   InFileNameEdit.Enabled:=false;
   OutFileNameEdit.Enabled:=false;
   LoadButton.Enabled:=false;
   StopButton.Enabled:=true;
  end
 else
  begin
   MAnimatedImage.Active:=false;
   MAnimatedImage.Visible:=false;
   IPEdit.Enabled:=true;
   InFileNameEdit.Enabled:=true;
   OutFileNameEdit.Enabled:=true;
   LoadButton.Enabled:=true;
   StopButton.Enabled:=false;
  end
end;

procedure TCopyFileForm.FormCreate(Sender: TObject);
begin
 MAnimatedImage:=TAnimateImage.Create(Self);
 MAnimatedImage.Parent:=Self;
 MAnimatedImage.Left:=240;
 MAnimatedImage.Top:=8;
 MAnimatedImage.Width:=32;
 MAnimatedImage.Height:=32;
 MAnimatedImage.Images:=MainImageList;
 MAnimatedImage.Visible:=false;

 StartFlag:=false;
 DragAcceptFiles(Handle, true);
 MainIniFile:=TIniFile.Create(MainIniName);
 try
  LastInFileName:=MainIniFile.ReadString('Main','InFileName','');
  LastOutFileName:=MainIniFile.ReadString('Main','OutFileName','');
  IPEdit.Text:=MainIniFile.ReadString('Main','IP','');
 finally
  MainIniFile.Free;
 end;
 editflag:=true;
 InFileNameEdit.Text:=LastInFileName;
 editflag:=true;
 OutFileNameEdit.Text:=LastOutFileName;
end;

procedure TCopyFileForm.LoadButtonClick(Sender: TObject);
var
 f1,f2:TFileStream;
 s,sl:integer;
begin
 if (LastInFileName>'') and (LastOutFileName>'')  then
  begin
   try f1:=TFileStream.Create(LastInFileName,fmOpenRead);
   except
    ShowMessage('    !!!'); exit;
   end;
   if FileExists(LastOutFileName) then
    try f2:=TFileStream.Create(LastOutFileName,fmOpenReadWrite);
    except
     try f1.Free; except end;
     ShowMessage('    !!!'); exit;
    end
   else
    try f2:=TFileStream.Create(LastOutFileName,fmCreate);
    except
     try f1.Free; except end;
     ShowMessage('    !!!'); exit;
    end;
   InFileSize:=f1.Size;
   OutFileSize:=f2.Size;
   StartTime:=Time; SizeC:=0;
   st1:=StartTime; sc1:=0; ac:=0;
   TSLabel.Caption:=IntToStr(InFileSize);
   SLabel.Caption:='';
   ShowProgressBar;
   StartFlag:=true;
   MainTimer.Enabled:=true;
   MenuEnabled;
   try
    f1.Position:=OutFileSize;
    f2.Position:=OutFileSize;
    s:=OutFileSize;
    repeat
     sl:=InFileSize-s;
     if sl>sb then sl:=sb;
     f1.ReadBuffer(buf,sl);
     if f1.Position<s+sl then break;
     f2.WriteBuffer(buf,sl);
     s:=s+sl;
     OutFileSize:=s;
     SizeC:=SizeC+sl;
     ShowProgressBar;
     Application.ProcessMessages;
     if not StartFlag then break;
    until OutFileSize=InFileSize;
   except
    StartFlag:=false;
    MainTimer.Enabled:=false;
    MenuEnabled;
    try f1.Free; except  end;
    try f2.Free; except  end;
    ShowMessage(' /!!!');
    exit;
   end;
   StartFlag:=false;
   MainTimer.Enabled:=false;
   TRLabel.Caption:='0:00:00';
   MenuEnabled;
   try f1.Free; except  end;
   try f2.Free; except  end;
  end
end;

procedure TCopyFileForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 if StartFlag then Action:=caNone
 else
  begin
   DragAcceptFiles(Handle, false);
   MainIniFile:=TIniFile.Create(MainIniName);
   try
    MainIniFile.WriteString('Main','InFileName',LastInFileName);
    MainIniFile.WriteString('Main','OutFileName',LastOutFileName);
    MainIniFile.WriteString('Main','IP',IPEdit.Text);
   finally
    MainIniFile.Free;
   end;
  end;
end;

procedure TCopyFileForm.MainTimerTimer(Sender: TObject);
var
 t:integer;
 a,a1,a2:real;
function c(s:string):string;
begin
 if length(s)=1 then Result:='0'+s
 else Result:=s;
end;
begin
 a1:=SizeC-sc1; a2:=(Time-st1)*86400;
 sc1:=SizeC; st1:=Time;
 if a2>0 then
  if ac=0 then ac:=a1/a2 else ac:=sqrt((sqr(ac)+sqr(a1/a2))/2);
 t:=Round((Time-StartTime)*86400);
 TLabel.Caption:=IntToStr(t div 3600)+':'+c(IntToStr((t mod 3600) div 60))+
 ':'+c(IntToStr(t mod 60));
 a:=InFileSize-OutFileSize;
 t:=Round(a/SizeC*t);
 TRLabel.Caption:=IntToStr(t div 3600)+':'+c(IntToStr((t mod 3600) div 60))+
 ':'+c(IntToStr(t mod 60));
 SLabel.Caption:=Format('%8.2f',[ac/1024])+' /';
 sb:=round(ac);
 if sb>SizeBuf then sb:=SizeBuf;
 if sb<8192 then sb:=8192;
end;

procedure TCopyFileForm.StopButtonClick(Sender: TObject);
begin
 StartFlag:=false;
end;

procedure TCopyFileForm.InFileNameEditDblClick(Sender: TObject);
begin
 FileOpenDialog.FileName:=LastInFileName;
 FileOpenDialog.InitialDir:='\\'+IPEdit.Text;
 if FileOpenDialog.Execute then
  begin
   editflag:=false;
   InFileNameEdit.Text:=FileOpenDialog.FileName;
  end;
end;

procedure TCopyFileForm.InFileNameEditChange(Sender: TObject);
begin
 if not(editflag) then
  begin
   LastInFileName:=InFileNameEdit.Text;
   LastOutFileName:=ExtractFileName(LastInFileName);
   editflag:=true;
   OutFileNameEdit.Text:=LastOutFileName;
  end
 else editflag:=false;
end;

procedure TCopyFileForm.OutFileNameEditDblClick(Sender: TObject);
begin
 FileSaveDialog.FileName:=LastOutFileName;
 if FileSaveDialog.Execute then
  begin
   editflag:=false;
   OutFileNameEdit.Text:=FileSaveDialog.FileName;
  end;
end;

procedure TCopyFileForm.OutFileNameEditChange(Sender: TObject);
begin
 if not(editflag) then
  LastOutFileName:=OutFileNameEdit.Text
 else editflag:=false;
end;

end.
