unit finddocu;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComObj, MODI_TLB, ActiveX;


type
  TMainForm = class(TForm)
    FindButton: TButton;
    FindStrMemo: TMemo;
    MainOpenDialog: TOpenDialog;
    FindStrLabel: TLabel;
    FindListBox: TListBox;
    SaveListButton: TButton;
    FindLabel: TLabel;
    OptCheckBox: TCheckBox;
    procedure FindButtonClick(Sender: TObject);
    procedure SaveListButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
 MainForm: TMainForm;
 doc:IDocument;

implementation

{$R *.dfm}

{function AppIsInstalled(strOLEObject:string):Boolean;
var
 ClassID:TCLSID;
begin
 Result:=(CLSIDFromProgID(PWideChar(WideString(strOLEObject)),ClassID)=S_OK)
end;

function GenerateRuntimeLicence(CLSID:TGUID;
 LicenceKey:WideString): boolean;
var
 ClassFactory2:IClassFactory2;
 licenceInfo:LICINFO;
begin
 result:=false;
 OleCheck(CoGetClassObject(CLSID, CLSCTX_INPROC_SERVER or
   CLSCTX_LOCAL_SERVER, nil, IClassFactory2, ClassFactory2));
 OleCheck(Classfactory2.GetLicInfo(LicenceInfo));
 if licenceInfo.fRuntimeKeyAvail then
  begin
   OleCheck(Classfactory2.RequestLicKey(0, LicenceKey));
   result:=true;
  end;
end;}

procedure TMainForm.FindButtonClick(Sender: TObject);
var
 Img:IImage;
 Layout:ILayout;
 ImgName:string;
 i,j,p,cnt:integer;
 fs,ns:string;
 f:boolean;
 GUID:TGUID;
label l;

begin
 if FindStrMemo.Text='' then
  begin
   Showmessage('   " "!');
   exit;
  end;
 if not MainOpenDialog.Execute then exit;
 CoInitialize(nil);
 CLSIDFromProgID('MODI.Document',GUID);
 try
  doc := CreateComObject(GUID) as IDocument;
 except
  Showmessage(' !');
  exit;
 end;
 try Doc.Create(''); except; end;
 cnt:=MainOpenDialog.Files.Count;
 FindListBox.Clear;
 for i:=0 to cnt-1 do
  begin
   FindLabel.Caption:=' ...'+IntToStr(i+1)+'  '+IntToStr(cnt);
   ImgName:=MainOpenDialog.Files.Strings[i];
   doc.create(ImgName);
   try
    doc.ocr(miLANG_RUSSIAN,true,true);
    Img := doc.Images[0] as IImage;
    Layout := IDispatch(Img.Layout) as ILayout;
    ns:=AnsiUpperCase(Layout.Text);
   except
    ns:='';
   end;
   f:=true; p:=0;
   for j:=0 to FindStrMemo.Lines.Count-1 do
    begin
l:
     ns:=Copy(ns,p+1,Length(ns)-p);
     fs:=AnsiUpperCase(FindStrMemo.Lines[j]);
     p:=Pos(fs,ns);
     if p=0 then begin f:=false; break end;
     if OptCheckBox.Checked then
      if (p>1) and (ns[p-1] in ['A'..'Z','0'..'9',''..'','']) then
       goto l;
    end;
   if f then
    FindListBox.Items.Add(ImgName);
   doc.Close(false);
   Img := nil;
   Layout := nil;
  end;
 doc:=nil;
 if FindListBox.Items.Count>0 then
  ShowMessage(' '+IntToStr(FindListBox.Items.Count)+' ')
 else
  ShowMessage('  ');
end;

procedure TMainForm.SaveListButtonClick(Sender: TObject);
begin
 FindListBox.Items.SaveToFile('findstr.txt');
end;

end.
