unit testu;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, TlHelp32, ExtCtrls, ShellApi, IniFiles, TrayIcon,
  Menus;

type
  THungTestForm = class(TForm)
    Proc1Label: TLabel;
    Proc1Edit: TEdit;
    Proc2Edit: TEdit;
    Proc2Label: TLabel;
    TimeIntLabel: TLabel;
    TimeIntEdit: TSpinEdit;
    StartButton: TButton;
    StopButton: TButton;
    MainTimer: TTimer;
    MainOpenDialog: TOpenDialog;
    procedure StartButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure MainTimerTimer(Sender: TObject);
    procedure LogMessage(const Message:string);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Proc1EditDblClick(Sender: TObject);
    procedure Proc2EditDblClick(Sender: TObject);
  private
    { Private declarations }
  public
   TI: TTrayIcon;
   procedure ShowClick(Sender: TObject);
   procedure AppMinimize(Sender:TObject);
   procedure StopProcess(const ProcExeName:string);
   procedure RunProcess(const ProcExeName:string);
    { Public declarations }
  end;

var
  HungTestForm: THungTestForm;
  WorkFlag:boolean;
  TimCount,TimTick:integer;
  HTIni:TIniFile;
  logfilename:string='hungtest.log';
  inifilename:string='hungtest.ini';

implementation

{$R *.dfm}

procedure THungTestForm.LogMessage(const Message:string);
var
 f:Integer;
 s:string;
begin
 f:=0;
 try
  if FileExists(logfilename) then
   f := FileOpen(logfilename, fmOpenReadWrite or fmShareExclusive)
  else
   f := FileCreate(logfilename, fmShareExclusive);
  if f = 0 then exit;
  FileSeek(f,0,2);
  s:=DateTimeToStr(Now)+' **** '+Message;
  s:=s+#13#10;
  FileWrite(f,s[1],length(s));
 except
 end;
 FileClose(f);
end;

function GetThreadID(ProcExeName:string):DWORD;
var
 hProcessSnap,hThreadSnap:Thandle;
 tp32:PROCESSENTRY32;
 te32:THREADENTRY32;
 h:Cardinal;
 s:string;
begin
 Result:=0;
 h:=0;
 s:=AnsiUppercase(ExtractFileName(Trim(ProcExeName)));
 hProcessSnap:=CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
 tp32.dwSize:=sizeof(PROCESSENTRY32);
 if (Process32First(hProcessSnap, tp32)) then
  repeat
   if AnsiUppercase(tp32.szExeFile)=s then
    begin
     h:=tp32.th32ProcessID;
     break;
    end;
 until not(Process32Next(hProcessSnap, tp32));
 CloseHandle (hProcessSnap);
 if h>0 then
  begin
   hThreadSnap:=CreateToolhelp32Snapshot(TH32CS_SNAPTHREAD, h);
   if (hThreadSnap=THandle(-1)) then exit;
   te32.dwSize:=sizeof(THREADENTRY32);
   te32.cntUsage:= 0;
   if (Thread32First(hThreadSnap, te32)) then
    repeat
     if te32.th32OwnerProcessID=h then
      begin
       Result:=te32.th32ThreadID;
       break;
      end;
    until not(Thread32Next(hThreadSnap, te32));
   CloseHandle (hThreadSnap);
  end;
end;

procedure THungTestForm.StopProcess(const ProcExeName:string);
var
 hProcessSnap:Thandle;
 tp32:PROCESSENTRY32;
 h:Thandle;
 s:string;
 v:cardinal;
begin
 s:=AnsiUppercase(ExtractFileName(Trim(ProcExeName)));
 if s='' then exit;
 hProcessSnap:=CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
 tp32.dwSize:=sizeof(PROCESSENTRY32);
 if (Process32First(hProcessSnap, tp32)) then
  repeat
   if AnsiUppercase(tp32.szExeFile)=s then
    begin
     h:=OpenProcess(PROCESS_ALL_ACCESS,false,tp32.th32ProcessID);
     if h>0 then
      begin
       LogMessage('  '+s);
       TerminateProcess(h,0);
       repeat
        GetExitCodeProcess(h,v);
        if v<>STILL_ACTIVE then break;
        Sleep(100);
       until false;
       CloseHandle(h);
      end;
     break;
    end;
 until not(Process32Next(hProcessSnap, tp32));
 CloseHandle (hProcessSnap);
end;

var
 HungFlag:boolean;

function IsHung(t:Cardinal):boolean;
function EnumThreadWndProc(Handle: HWND; l: lparam): Bool; stdcall;
var
 r:DWORD;
begin
 Result := false;
 if SendMessageTimeout(Handle, WM_NULL, 0, 0, SMTO_ABORTIFHUNG, 10000, r)<>0 then
  if r=0 then
   HungFlag:=false;
end;
begin
 HungFlag:=true;
 EnumThreadWindows(t,@EnumThreadWndProc,0);
 Result:=HungFlag;
end;

procedure THungTestForm.StartButtonClick(Sender: TObject);
var
 i:integer;
begin
 if Trim(Proc1Edit.Text)='' then exit;
 TimTick:=0;
 TimCount:=StrToInt(TimeIntEdit.Text);
 MainTimer.Enabled:=true;
 StartButton.Enabled:=false;
 StopButton.Enabled:=true;
 for i:=0 to ComponentCount-1 do
  if Components[i] is TCustomEdit then (Components[i] as TCustomEdit).Enabled:=false;
end;

procedure THungTestForm.StopButtonClick(Sender: TObject);
var
 i:integer;
begin
 MainTimer.Enabled:=false;
 StartButton.Enabled:=true;
 StopButton.Enabled:=false;
 for i:=0 to ComponentCount-1 do
  if Components[i] is TCustomEdit then (Components[i] as TCustomEdit).Enabled:=true;
end;

procedure THungTestForm.RunProcess(const ProcExeName:string);
begin
 if Trim(ProcExeName)='' then exit;
 LogMessage('  '+ProcExeName);
 ShellExecute(0,'',PChar(ProcExeName),'','',SW_SHOWNORMAL);
end;

procedure THungTestForm.MainTimerTimer(Sender: TObject);
var
 t1:cardinal;
begin
 MainTimer.Enabled:=false;
 if MainTimer.Interval<>1000 then
  begin
   MainTimer.Interval:=1000;
   StartButtonClick(Self);
   Application.Minimize;
   exit;
  end;
 inc(TimTick);
 if TimTick>=TimCount then
  begin
   TimTick:=0;
   t1:=GetThreadID(Proc1Edit.Text);
   if t1>0 then
    if IsHung(t1) then
     begin
      StopProcess(Proc1Edit.Text);
      StopProcess(Proc2Edit.Text);
      RunProcess(Proc1Edit.Text);
      RunProcess(Proc2Edit.Text);
     end
    else
   else
    begin
     RunProcess(Proc1Edit.Text);
     t1:=GetThreadID(Proc2Edit.Text);
     if t1=0 then
      RunProcess(Proc2Edit.Text);
    end;
  end;
 MainTimer.Enabled:=true;
end;

function FileSpec(const p,f:string):string;
begin
 if p='' then
  Result:=f
 else
  if p[length(p)]='\' then Result:=p+f
  else Result:=p+'\'+f;
end;

procedure THungTestForm.ShowClick(Sender: TObject);
begin
 ShowWindow(Application.Handle,SW_SHOWNORMAL);
 ShowWindow(HungTestForm.Handle,SW_SHOWNORMAL);
 SetForegroundWindow(HungTestForm.Handle);
end;

procedure THungTestForm.FormCreate(Sender: TObject);
var
 n:integer;
begin
 inifilename:=FileSpec(ExtractFilePath(paramstr(0)),inifilename);
 logfilename:=FileSpec(ExtractFilePath(paramstr(0)),logfilename);
 Application.OnMinimize:=AppMinimize;
 TI:=TTrayIcon.create(HungTestForm);
 TI.Icon:=HungTestForm.Icon;
 TI.OnDblClick:=ShowClick;
 TI.ToolTip:='HungTest 1.0';
 TI.IDMessage:='$$$HUNGTEST$$$';
 TI.Loaded;
 TI.Active:=true;
 HTIni:=TIniFile.Create(inifilename);
 try
  Proc1Edit.Text:=HTIni.ReadString('Process','Process1','');
  Proc2Edit.Text:=HTIni.ReadString('Process','Process2','');
  n:=HTIni.ReadInteger('Process','TestInterval',60);
  if (n<TimeIntEdit.MinValue) then n:=TimeIntEdit.MinValue;
  if (n>TimeIntEdit.MaxValue) then n:=TimeIntEdit.MaxValue;
  TimeIntEdit.Value:=n;
 finally
  HTIni.Free;
 end;
end;

procedure THungTestForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 HTIni:=TIniFile.Create(inifilename);
 try
  HTIni.WriteString('Process','Process1',Proc1Edit.Text);
  HTIni.WriteString('Process','Process2',Proc2Edit.Text);
  HTIni.WriteInteger('Process','TestInterval',TimeIntEdit.Value);
 finally
  HTIni.Free;
 end;
end;

procedure THungTestForm.AppMinimize(Sender:TObject);
begin
 ShowWindow(Application.Handle,SW_HIDE);
 ShowWindow(HungTestForm.Handle,SW_HIDE);
end;

procedure THungTestForm.Proc1EditDblClick(Sender: TObject);
begin
 MainOpenDialog.FileName:=Proc1Edit.Text;
 MainOpenDialog.InitialDir:=ExtractFilePath(Proc1Edit.Text);
 if MainOpenDialog.Execute then
   Proc1Edit.Text:=MainOpenDialog.FileName;
end;


procedure THungTestForm.Proc2EditDblClick(Sender: TObject);
begin
 MainOpenDialog.FileName:=Proc2Edit.Text;
 MainOpenDialog.InitialDir:=ExtractFilePath(Proc2Edit.Text);
 if MainOpenDialog.Execute then
   Proc2Edit.Text:=MainOpenDialog.FileName;
end;

end.
