unit MODI_TLB;

{$TYPEDADDRESS OFF} // Unit must be compiled without type-checked pointers.
{$WARN SYMBOL_PLATFORM OFF}
{$WRITEABLECONST ON}

interface

uses ActiveX;

const
  // TypeLibrary Major and minor versions
  MODIMajorVersion = 11;
  MODIMinorVersion = 0;

  LIBID_MODI: TGUID = '{A5EDEDF4-2BBC-45F3-822B-E60C278A1A79}';

  IID_IMiFont: TGUID = '{1FFC9A7B-7606-4C97-8119-78673E9D4821}';
  IID_IMiRect: TGUID = '{87D6FB47-7CFA-4DB3-82CD-E8DCC5BDA7AB}';
  IID_IMiRects: TGUID = '{895C88A9-8598-44CC-91C4-8010AE2475EB}';
  IID_IWord: TGUID = '{5612275B-B4F1-42AF-B696-360D40DF041D}';
  IID_IWords: TGUID = '{D8363824-4B07-423B-8803-49B470434F3D}';
  IID_ILayout: TGUID = '{C300C846-A3FD-4A5B-AD65-4A6AB46B7821}';
  IID_IImage: TGUID = '{AC0D48A6-886D-4EB5-A8A1-093D60B9A84A}';
  IID_IImages: TGUID = '{77096557-54CA-45C8-81C9-E70C2ABAA0FB}';
  IID_IDocument: TGUID = '{D4073843-A58A-469A-A8E2-CFF3FF77EE4E}';
  DIID__IDocumentEvents: TGUID = '{0CF31963-5E4D-4772-AE8D-82FE5A082B26}';
  CLASS_Document: TGUID = '{40942A6C-1520-4132-BDF8-BDC1F71F547B}';
  CLASS_Layout: TGUID = '{1AFC4117-128E-4314-9D53-64CBDA5C7E02}';
  DIID__IImageEvents: TGUID = '{99F3A122-448F-4D36-8243-48BFE32D50B2}';
  CLASS_Image: TGUID = '{56F963EC-6EFC-4A6B-9A1E-5BFE545C89D0}';
  CLASS_Word: TGUID = '{5995E30F-59EB-42AE-BDCF-8908271C0B32}';
  CLASS_MiFont: TGUID = '{C5EAE79B-ACCC-4E51-8ED5-A16F42FB7B1F}';
  CLASS_Words: TGUID = '{72ACBCE3-9067-4D5E-9539-3497FECD032D}';
  CLASS_Images: TGUID = '{F961D185-2CC1-43DB-80AB-567FA10251EC}';
  CLASS_MiRect: TGUID = '{00607E44-15DF-49BC-AF0C-A9023E060791}';
  CLASS_MiRects: TGUID = '{CB2FBD52-56C1-4DD8-897F-961D1543B877}';
  IID_IMiSelectRect: TGUID = '{EA280C3C-E4B7-42BF-ACC8-FE3AD3581638}';
  IID_IMiSelectRects: TGUID = '{3A1E1B7A-C041-4DDC-BF3B-042A0B95B82B}';
  IID_IMiSelectableItem: TGUID = '{01C4414A-D123-4BC7-A1FA-64E376C01655}';
  IID_IMiSelectableImage: TGUID = '{F6379198-3B20-461A-B3A9-191945752557}';
  IID_IMiSearchCallback: TGUID = '{8376D508-78CA-416D-A903-2ED62E91E29B}';
  IID_IMiDocView: TGUID = '{F958524A-8422-4B07-B69E-199F2421ED89}';
  DIID__IMiDocViewEvents: TGUID = '{9028B775-EC59-4118-862A-EFDEAF5955A4}';
  IID_IMiDocSearch: TGUID = '{BC06ED64-A40C-4FB4-A660-AC6DBC752292}';
  CLASS_MiDocView: TGUID = '{EF347A62-BA21-42E4-94A0-1C0A6D7FDFE7}';
  CLASS_MiDocSearch: TGUID = '{FA554DB9-C806-46A9-AEF8-B5AF891A94F9}';
  CLASS_MiSelectRect: TGUID = '{A4D2B51F-809F-4C53-9147-5516871816BD}';
  CLASS_MiSelectRects: TGUID = '{23E9E94B-C202-4E9C-8C2E-F53BC536FF1D}';

// *********************************************************************//
// Declaration of Enumerations defined in Type Library
// *********************************************************************//
// Constants for enum MiFONT_FAMILY
type
  MiFONT_FAMILY = TOleEnum;
const
  miFFamily_Helvetica = $00000001;
  miFFamily_Times = $00000002;
  miFFamily_Century = $00000003;
  miFFamily_TimesCentury = $00000004;
  miFFamily_HelveticaCentury = $00000005;
  miFFamily_DEFAULT = $00000006;

// Constants for enum MiFONT_FACE_STYLE
type
  MiFONT_FACE_STYLE = TOleEnum;
const
  miFFace_ROMAN = $00000001;
  miFFace_ITALIC = $00000002;
  miFFace_BOLD = $00000003;
  miFFace_BOLD_ITALIC = $00000004;

// Constants for enum MiFONT_SERIF_STYLE
type
  MiFONT_SERIF_STYLE = TOleEnum;
const
  miFSerifSANS = $00000001;
  miFSerifTHIN = $00000002;
  miFSerifSQ = $00000003;
  miFSerifRND = $00000004;
  miFSerifSTYLE_UNKNOWN = $00000005;

// Constants for enum MiTHUMBNAIL_SIZE
type
  MiTHUMBNAIL_SIZE = TOleEnum;
const
  miTHUMB_SIZE_TINY = $00000000;
  miTHUMB_SIZE_SMALL = $00000001;
  miTHUMB_SIZE_MEDIUM = $00000002;
  miTHUMB_SIZE_LARGE = $00000003;
  miTHUMB_SIZE_MAXIMUM = $00000003;

// Constants for enum MiCOMP_LEVEL
type
  MiCOMP_LEVEL = TOleEnum;
const
  miCOMP_LEVEL_LOW = $00000000;
  miCOMP_LEVEL_MEDIUM = $00000001;
  miCOMP_LEVEL_HIGH = $00000002;

// Constants for enum MiCOMP_TYPE
type
  MiCOMP_TYPE = TOleEnum;
const
  miCOMP_UNKNOWN = $00000000;
  miCOMP_TIFF_NONE = $00000001;
  miCOMP_TIFF_CCITT1D = $00000002;
  miCOMP_TIFF_CCITT3 = $00000003;
  miCOMP_TIFF_CCITT4 = $00000004;
  miCOMP_TIFF_LZW = $00000005;
  miCOMP_TIFF_JPEG6 = $00000006;
  miCOMP_TIFF_JPEG = $00000007;
  miCOMP_TIFF_PACK = $00008005;
  miCOMP_MODI_BLC = $0000879E;
  miCOMP_MODI_VECTOR = $0000879F;
  miCOMP_MODI_PTC = $000087A0;

// Constants for enum MiFILE_FORMAT
type
  MiFILE_FORMAT = TOleEnum;
const
  miFILE_FORMAT_TIFF = $00000001;
  miFILE_FORMAT_TIFF_LOSSLESS = $00000002;
  miFILE_FORMAT_MDI = $00000004;
  miFILE_FORMAT_DEFAULTVALUE = $FFFFFFFF;

// Constants for enum MiPRINT_FITMODES
type
  MiPRINT_FITMODES = TOleEnum;
const
  miPRINT_ACTUALSIZE = $00000000;
  miPRINT_PAGE = $00000001;

// Constants for enum MiLANGUAGES
type
  MiLANGUAGES = TOleEnum;
const
  miLANG_CHINESE_SIMPLIFIED = $00000804;
  miLANG_CHINESE_TRADITIONAL = $00000404;
  miLANG_CZECH = $00000005;
  miLANG_DANISH = $00000006;
  miLANG_DUTCH = $00000013;
  miLANG_ENGLISH = $00000009;
  miLANG_FINNISH = $0000000B;
  miLANG_FRENCH = $0000000C;
  miLANG_GERMAN = $00000007;
  miLANG_GREEK = $00000008;
  miLANG_HUNGARIAN = $0000000E;
  miLANG_ITALIAN = $00000010;
  miLANG_JAPANESE = $00000011;
  miLANG_KOREAN = $00000012;
  miLANG_NORWEGIAN = $00000014;
  miLANG_POLISH = $00000015;
  miLANG_PORTUGUESE = $00000016;
  miLANG_RUSSIAN = $00000019;
  miLANG_SPANISH = $0000000A;
  miLANG_SWEDISH = $0000001D;
  miLANG_TURKISH = $0000001F;
  miLANG_SYSDEFAULT = $00000800;

// Constants for enum MiActionState
type
  MiActionState = TOleEnum;
const
  miASTATE_NONE = $00000000;
  miASTATE_PAN = $00000001;
  miASTATE_ZOOM = $00000002;
  miASTATE_AnntSELECT = $00000003;
  miASTATE_HIDDEN = $00000004;
  miASTATE_SELECT = $00000005;

// Constants for enum MiDocviewMode
type
  MiDocviewMode = TOleEnum;
const
  miDOCVIEWMODE_CONTINOUSPAGEVIEW = $00000000;
  miDOCVIEWMODE_SINGLEPAGEVIEW = $00000001;
  miDOCVIEWMODE_TWOCOLUMNS_CONTINOUSPAGEVIEW = $00000004;

// Constants for enum MiVIEWLAYER
type
  MiVIEWLAYER = TOleEnum;
const
  miVIEWLAYER_RICHINK = $00000000;

// Constants for enum MiFITMODE
type
  MiFITMODE = TOleEnum;
const
  miFree = $00000000;
  miByWidth = $00000001;
  miByHeight = $00000002;
  miByWindow = $00000003;
  miByTextWidth = $00000004;

type

// *********************************************************************//
// Forward declaration of types defined in TypeLibrary
// *********************************************************************//
  IMiFont = interface;
  IMiFontDisp = dispinterface;
  IMiRect = interface;
  IMiRectDisp = dispinterface;
  IMiRects = interface;
  IMiRectsDisp = dispinterface;
  IWord = interface;
  IWordDisp = dispinterface;
  IWords = interface;
  IWordsDisp = dispinterface;
  ILayout = interface;
  ILayoutDisp = dispinterface;
  IImage = interface;
  IImageDisp = dispinterface;
  IImages = interface;
  IImagesDisp = dispinterface;
  IDocument = interface;
  IDocumentDisp = dispinterface;
  _IDocumentEvents = dispinterface;
  _IImageEvents = dispinterface;
  IMiSelectRect = interface;
  IMiSelectRectDisp = dispinterface;
  IMiSelectRects = interface;
  IMiSelectRectsDisp = dispinterface;
  IMiSelectableItem = interface;
  IMiSelectableItemDisp = dispinterface;
  IMiSelectableImage = interface;
  IMiSelectableImageDisp = dispinterface;
  IMiSearchCallback = interface;
  IMiDocView = interface;
  IMiDocViewDisp = dispinterface;
  _IMiDocViewEvents = dispinterface;
  IMiDocSearch = interface;
  IMiDocSearchDisp = dispinterface;

// *********************************************************************//
// Declaration of CoClasses defined in Type Library
// (NOTE: Here we map each CoClass to its Default Interface)
// *********************************************************************//
  Document = IDocument;
  Layout = ILayout;
  Image = IImage;
  Word = IWord;
  MiFont = IMiFont;
  Words = IWords;
  Images = IImages;
  MiRect = IMiRect;
  MiRects = IMiRects;
  MiDocView = IMiDocView;
  MiDocSearch = IMiDocSearch;
  MiSelectRect = IMiSelectRect;
  MiSelectRects = IMiSelectRects;


// *********************************************************************//
// Declaration of structures, unions and aliases.
// *********************************************************************//
  PDouble1 = ^Double; {*}
  POleVariant1 = ^OleVariant; {*}
  PPUserType1 = ^IMiSelectableItem; {*}


// *********************************************************************//
// Interface: IMiFont
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {1FFC9A7B-7606-4C97-8119-78673E9D4821}
// *********************************************************************//
  IMiFont = interface(IDispatch)
    ['{1FFC9A7B-7606-4C97-8119-78673E9D4821}']
    function  Get_Family: MiFONT_FAMILY; safecall;
    function  Get_FaceStyle: MiFONT_FACE_STYLE; safecall;
    function  Get_SerifStyle: MiFONT_SERIF_STYLE; safecall;
    function  Get_FontSize: Smallint; safecall;
    property Family: MiFONT_FAMILY read Get_Family;
    property FaceStyle: MiFONT_FACE_STYLE read Get_FaceStyle;
    property SerifStyle: MiFONT_SERIF_STYLE read Get_SerifStyle;
    property FontSize: Smallint read Get_FontSize;
  end;

// *********************************************************************//
// DispIntf:  IMiFontDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {1FFC9A7B-7606-4C97-8119-78673E9D4821}
// *********************************************************************//
  IMiFontDisp = dispinterface
    ['{1FFC9A7B-7606-4C97-8119-78673E9D4821}']
    property Family: MiFONT_FAMILY readonly dispid 1;
    property FaceStyle: MiFONT_FACE_STYLE readonly dispid 3;
    property SerifStyle: MiFONT_SERIF_STYLE readonly dispid 4;
    property FontSize: Smallint readonly dispid 5;
  end;

// *********************************************************************//
// Interface: IMiRect
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {87D6FB47-7CFA-4DB3-82CD-E8DCC5BDA7AB}
// *********************************************************************//
  IMiRect = interface(IDispatch)
    ['{87D6FB47-7CFA-4DB3-82CD-E8DCC5BDA7AB}']
    function  Get_Top: Integer; safecall;
    function  Get_Left: Integer; safecall;
    function  Get_Right: Integer; safecall;
    function  Get_Bottom: Integer; safecall;
    property Top: Integer read Get_Top;
    property Left: Integer read Get_Left;
    property Right: Integer read Get_Right;
    property Bottom: Integer read Get_Bottom;
  end;

// *********************************************************************//
// DispIntf:  IMiRectDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {87D6FB47-7CFA-4DB3-82CD-E8DCC5BDA7AB}
// *********************************************************************//
  IMiRectDisp = dispinterface
    ['{87D6FB47-7CFA-4DB3-82CD-E8DCC5BDA7AB}']
    property Top: Integer readonly dispid 1;
    property Left: Integer readonly dispid 2;
    property Right: Integer readonly dispid 3;
    property Bottom: Integer readonly dispid 4;
  end;

// *********************************************************************//
// Interface: IMiRects
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {895C88A9-8598-44CC-91C4-8010AE2475EB}
// *********************************************************************//
  IMiRects = interface(IDispatch)
    ['{895C88A9-8598-44CC-91C4-8010AE2475EB}']
    function  Get_Count: Integer; safecall;
    function  Get__NewEnum: IUnknown; safecall;
    function  Get_Item(Index: Integer): IDispatch; safecall;
    property Count: Integer read Get_Count;
    property _NewEnum: IUnknown read Get__NewEnum;
    property Item[Index: Integer]: IDispatch read Get_Item; default;
  end;

// *********************************************************************//
// DispIntf:  IMiRectsDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {895C88A9-8598-44CC-91C4-8010AE2475EB}
// *********************************************************************//
  IMiRectsDisp = dispinterface
    ['{895C88A9-8598-44CC-91C4-8010AE2475EB}']
    property Count: Integer readonly dispid 1;
    property _NewEnum: IUnknown readonly dispid -4;
    property Item[Index: Integer]: IDispatch readonly dispid 0; default;
  end;

// *********************************************************************//
// Interface: IWord
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {5612275B-B4F1-42AF-B696-360D40DF041D}
// *********************************************************************//
  IWord = interface(IDispatch)
    ['{5612275B-B4F1-42AF-B696-360D40DF041D}']
    function  Get_RecognitionConfidence: Smallint; safecall;
    function  Get_FontId: Integer; safecall;
    function  Get_LineId: Integer; safecall;
    function  Get_RegionId: Integer; safecall;
    function  Get_Text: WideString; safecall;
    function  Get_Font: IMiFont; safecall;
    function  Get_Id: Integer; safecall;
    function  Get_Rects: IMiRects; safecall;
    property RecognitionConfidence: Smallint read Get_RecognitionConfidence;
    property FontId: Integer read Get_FontId;
    property LineId: Integer read Get_LineId;
    property RegionId: Integer read Get_RegionId;
    property Text: WideString read Get_Text;
    property Font: IMiFont read Get_Font;
    property Id: Integer read Get_Id;
    property Rects: IMiRects read Get_Rects;
  end;

// *********************************************************************//
// DispIntf:  IWordDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {5612275B-B4F1-42AF-B696-360D40DF041D}
// *********************************************************************//
  IWordDisp = dispinterface
    ['{5612275B-B4F1-42AF-B696-360D40DF041D}']
    property RecognitionConfidence: Smallint readonly dispid 1;
    property FontId: Integer readonly dispid 2;
    property LineId: Integer readonly dispid 3;
    property RegionId: Integer readonly dispid 4;
    property Text: WideString readonly dispid 6;
    property Font: IMiFont readonly dispid 7;
    property Id: Integer readonly dispid 8;
    property Rects: IMiRects readonly dispid 9;
  end;

// *********************************************************************//
// Interface: IWords
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {D8363824-4B07-423B-8803-49B470434F3D}
// *********************************************************************//
  IWords = interface(IDispatch)
    ['{D8363824-4B07-423B-8803-49B470434F3D}']
    function  Get_Count: Integer; safecall;
    function  Get__NewEnum: IUnknown; safecall;
    function  Get_Item(Index: Integer): IDispatch; safecall;
    property Count: Integer read Get_Count;
    property _NewEnum: IUnknown read Get__NewEnum;
    property Item[Index: Integer]: IDispatch read Get_Item; default;
  end;

// *********************************************************************//
// DispIntf:  IWordsDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {D8363824-4B07-423B-8803-49B470434F3D}
// *********************************************************************//
  IWordsDisp = dispinterface
    ['{D8363824-4B07-423B-8803-49B470434F3D}']
    property Count: Integer readonly dispid 1;
    property _NewEnum: IUnknown readonly dispid -4;
    property Item[Index: Integer]: IDispatch readonly dispid 0; default;
  end;

// *********************************************************************//
// Interface: ILayout
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {C300C846-A3FD-4A5B-AD65-4A6AB46B7821}
// *********************************************************************//
  ILayout = interface(IDispatch)
    ['{C300C846-A3FD-4A5B-AD65-4A6AB46B7821}']
    function  Get_Language: Integer; safecall;
    function  Get_NumChars: Integer; safecall;
    function  Get_NumWords: Integer; safecall;
    function  Get_NumFonts: Integer; safecall;
    function  Get_Text: WideString; safecall;
    function  Get_Words: IWords; safecall;
    property Language: Integer read Get_Language;
    property NumChars: Integer read Get_NumChars;
    property NumWords: Integer read Get_NumWords;
    property NumFonts: Integer read Get_NumFonts;
    property Text: WideString read Get_Text;
    property Words: IWords read Get_Words;
  end;

// *********************************************************************//
// DispIntf:  ILayoutDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {C300C846-A3FD-4A5B-AD65-4A6AB46B7821}
// *********************************************************************//
  ILayoutDisp = dispinterface
    ['{C300C846-A3FD-4A5B-AD65-4A6AB46B7821}']
    property Language: Integer readonly dispid 1;
    property NumChars: Integer readonly dispid 2;
    property NumWords: Integer readonly dispid 3;
    property NumFonts: Integer readonly dispid 4;
    property Text: WideString readonly dispid 5;
    property Words: IWords readonly dispid 6;
  end;

// *********************************************************************//
// Interface: IImage
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {AC0D48A6-886D-4EB5-A8A1-093D60B9A84A}
// *********************************************************************//
  IImage = interface(IDispatch)
    ['{AC0D48A6-886D-4EB5-A8A1-093D60B9A84A}']
    function  Get_Layout: ILayout; safecall;
    function  Get_PixelWidth: Integer; safecall;
    function  Get_PixelHeight: Integer; safecall;
    function  Get_XDPI: Integer; safecall;
    function  Get_YDPI: Integer; safecall;
    function  Get_BitsPerPixel: Integer; safecall;
    function  Get_Thumbnail(ThumbSize: MiTHUMBNAIL_SIZE): IPictureDisp; safecall;
    function  Get_Picture: IPictureDisp; safecall;
    function  Get_Compression: MiCOMP_TYPE; safecall;
    procedure OCR(LangId: MiLANGUAGES; OCROrientImage: WordBool; OCRStraightenImage: WordBool); safecall;
    procedure Rotate(Angle: Integer); safecall;
    property Layout: ILayout read Get_Layout;
    property PixelWidth: Integer read Get_PixelWidth;
    property PixelHeight: Integer read Get_PixelHeight;
    property XDPI: Integer read Get_XDPI;
    property YDPI: Integer read Get_YDPI;
    property BitsPerPixel: Integer read Get_BitsPerPixel;
    property Thumbnail[ThumbSize: MiTHUMBNAIL_SIZE]: IPictureDisp read Get_Thumbnail;
    property Picture: IPictureDisp read Get_Picture;
    property Compression: MiCOMP_TYPE read Get_Compression;
  end;

// *********************************************************************//
// DispIntf:  IImageDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {AC0D48A6-886D-4EB5-A8A1-093D60B9A84A}
// *********************************************************************//
  IImageDisp = dispinterface
    ['{AC0D48A6-886D-4EB5-A8A1-093D60B9A84A}']
    property Layout: ILayout readonly dispid 1;
    property PixelWidth: Integer readonly dispid 2;
    property PixelHeight: Integer readonly dispid 3;
    property XDPI: Integer readonly dispid 4;
    property YDPI: Integer readonly dispid 5;
    property BitsPerPixel: Integer readonly dispid 6;
    property Thumbnail[ThumbSize: MiTHUMBNAIL_SIZE]: IPictureDisp readonly dispid 7;
    property Picture: IPictureDisp readonly dispid 8;
    property Compression: MiCOMP_TYPE readonly dispid 9;
    procedure OCR(LangId: MiLANGUAGES; OCROrientImage: WordBool; OCRStraightenImage: WordBool); dispid 10;
    procedure Rotate(Angle: Integer); dispid 11;
  end;

// *********************************************************************//
// Interface: IImages
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {77096557-54CA-45C8-81C9-E70C2ABAA0FB}
// *********************************************************************//
  IImages = interface(IDispatch)
    ['{77096557-54CA-45C8-81C9-E70C2ABAA0FB}']
    function  Get_Count: Integer; safecall;
    procedure Add(const Page: IDispatch; const BeforePage: IDispatch); safecall;
    function  Get__NewEnum: IUnknown; safecall;
    function  Get_Item(Index: Integer): IDispatch; safecall;
    procedure Remove(const Page: IDispatch); safecall;
    property Count: Integer read Get_Count;
    property _NewEnum: IUnknown read Get__NewEnum;
    property Item[Index: Integer]: IDispatch read Get_Item; default;
  end;

// *********************************************************************//
// DispIntf:  IImagesDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {77096557-54CA-45C8-81C9-E70C2ABAA0FB}
// *********************************************************************//
  IImagesDisp = dispinterface
    ['{77096557-54CA-45C8-81C9-E70C2ABAA0FB}']
    property Count: Integer readonly dispid 1;
    procedure Add(const Page: IDispatch; const BeforePage: IDispatch); dispid 2;
    property _NewEnum: IUnknown readonly dispid -4;
    property Item[Index: Integer]: IDispatch readonly dispid 0; default;
    procedure Remove(const Page: IDispatch); dispid 5;
  end;

// *********************************************************************//
// Interface: IDocument
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {D4073843-A58A-469A-A8E2-CFF3FF77EE4E}
// *********************************************************************//
  IDocument = interface(IDispatch)
    ['{D4073843-A58A-469A-A8E2-CFF3FF77EE4E}']
    procedure Save; safecall;
    procedure Close(SaveChanges: WordBool); safecall;
    procedure SaveAs(const FileName: WideString; FileFormat: MiFILE_FORMAT; CompLevel: MiCOMP_LEVEL); safecall;
    function  Get_Images: IImages; safecall;
    function  Get_BuiltInDocumentProperties: IDispatch; safecall;
    function  Get_CustomDocumentProperties: IDispatch; safecall;
    procedure Create(const FileOpen: WideString); safecall;
    function  Get_Dirty: WordBool; safecall;
    procedure OCR(LangId: MiLANGUAGES; OCROrientImage: WordBool; OCRStraightenImage: WordBool); stdcall;
    procedure PrintOut(From: Integer; To_: Integer; Copies: Integer; const PrinterName: WideString;
                       const PrintToFileName: WideString; PrintAnnotation: WordBool;
                       FitMode: MiPRINT_FITMODES); safecall;
    property Images: IImages read Get_Images;
    property BuiltInDocumentProperties: IDispatch read Get_BuiltInDocumentProperties;
    property CustomDocumentProperties: IDispatch read Get_CustomDocumentProperties;
    property Dirty: WordBool read Get_Dirty;
  end;

// *********************************************************************//
// DispIntf:  IDocumentDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {D4073843-A58A-469A-A8E2-CFF3FF77EE4E}
// *********************************************************************//
  IDocumentDisp = dispinterface
    ['{D4073843-A58A-469A-A8E2-CFF3FF77EE4E}']
    procedure Save; dispid 2;
    procedure Close(SaveChanges: WordBool); dispid 3;
    procedure SaveAs(const FileName: WideString; FileFormat: MiFILE_FORMAT; CompLevel: MiCOMP_LEVEL); dispid 4;
    property Images: IImages readonly dispid 5;
    property BuiltInDocumentProperties: IDispatch readonly dispid 6;
    property CustomDocumentProperties: IDispatch readonly dispid 7;
    procedure Create(const FileOpen: WideString); dispid 8;
    property Dirty: WordBool readonly dispid 9;
    procedure OCR(LangId: MiLANGUAGES; OCROrientImage: WordBool; OCRStraightenImage: WordBool); dispid 10;
    procedure PrintOut(From: Integer; To_: Integer; Copies: Integer; const PrinterName: WideString; 
                       const PrintToFileName: WideString; PrintAnnotation: WordBool;
                       FitMode: MiPRINT_FITMODES); dispid 11;
  end;

// *********************************************************************//
// DispIntf:  _IDocumentEvents
// Flags:     (4096) Dispatchable
// GUID:      {0CF31963-5E4D-4772-AE8D-82FE5A082B26}
// *********************************************************************//
  _IDocumentEvents = dispinterface
    ['{0CF31963-5E4D-4772-AE8D-82FE5A082B26}']
    procedure OnOCRProgress(Progress: SYSINT; var Cancel: WordBool); dispid 1;
  end;

// *********************************************************************//
// DispIntf:  _IImageEvents
// Flags:     (4096) Dispatchable
// GUID:      {99F3A122-448F-4D36-8243-48BFE32D50B2}
// *********************************************************************//
  _IImageEvents = dispinterface
    ['{99F3A122-448F-4D36-8243-48BFE32D50B2}']
  end;

// *********************************************************************//
// Interface: IMiSelectRect
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {EA280C3C-E4B7-42BF-ACC8-FE3AD3581638}
// *********************************************************************//
  IMiSelectRect = interface(IDispatch)
    ['{EA280C3C-E4B7-42BF-ACC8-FE3AD3581638}']
    function  Get_PageNumber: Integer; safecall;
    function  Get_Left: Integer; safecall;
    function  Get_Top: Integer; safecall;
    function  Get_Right: Integer; safecall;
    function  Get_Bottom: Integer; safecall;
    property PageNumber: Integer read Get_PageNumber;
    property Left: Integer read Get_Left;
    property Top: Integer read Get_Top;
    property Right: Integer read Get_Right;
    property Bottom: Integer read Get_Bottom;
  end;

// *********************************************************************//
// DispIntf:  IMiSelectRectDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {EA280C3C-E4B7-42BF-ACC8-FE3AD3581638}
// *********************************************************************//
  IMiSelectRectDisp = dispinterface
    ['{EA280C3C-E4B7-42BF-ACC8-FE3AD3581638}']
    property PageNumber: Integer readonly dispid 1;
    property Left: Integer readonly dispid 2;
    property Top: Integer readonly dispid 3;
    property Right: Integer readonly dispid 4;
    property Bottom: Integer readonly dispid 5;
  end;

// *********************************************************************//
// Interface: IMiSelectRects
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {3A1E1B7A-C041-4DDC-BF3B-042A0B95B82B}
// *********************************************************************//
  IMiSelectRects = interface(IDispatch)
    ['{3A1E1B7A-C041-4DDC-BF3B-042A0B95B82B}']
    function  Get_Count: Integer; safecall;
    function  Get__NewEnum: IUnknown; safecall;
    function  Get_Item(Index: Integer): IDispatch; safecall;
    property Count: Integer read Get_Count;
    property _NewEnum: IUnknown read Get__NewEnum;
    property Item[Index: Integer]: IDispatch read Get_Item; default;
  end;

// *********************************************************************//
// DispIntf:  IMiSelectRectsDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {3A1E1B7A-C041-4DDC-BF3B-042A0B95B82B}
// *********************************************************************//
  IMiSelectRectsDisp = dispinterface
    ['{3A1E1B7A-C041-4DDC-BF3B-042A0B95B82B}']
    property Count: Integer readonly dispid 1;
    property _NewEnum: IUnknown readonly dispid -4;
    property Item[Index: Integer]: IDispatch readonly dispid 0; default;
  end;

// *********************************************************************//
// Interface: IMiSelectableItem
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {01C4414A-D123-4BC7-A1FA-64E376C01655}
// *********************************************************************//
  IMiSelectableItem = interface(IDispatch)
    ['{01C4414A-D123-4BC7-A1FA-64E376C01655}']
    procedure CopyToClipboard; safecall;
    function  Get_Text: WideString; safecall;
    function  Get_Words: IDispatch; safecall;
    function  GetSelectRects: IMiSelectRects; safecall;
    property Text: WideString read Get_Text;
    property Words: IDispatch read Get_Words;
  end;

// *********************************************************************//
// DispIntf:  IMiSelectableItemDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {01C4414A-D123-4BC7-A1FA-64E376C01655}
// *********************************************************************//
  IMiSelectableItemDisp = dispinterface
    ['{01C4414A-D123-4BC7-A1FA-64E376C01655}']
    procedure CopyToClipboard; dispid 1;
    property Text: WideString readonly dispid 2;
    property Words: IDispatch readonly dispid 3;
    function  GetSelectRects: IMiSelectRects; dispid 4;
  end;

// *********************************************************************//
// Interface: IMiSelectableImage
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {F6379198-3B20-461A-B3A9-191945752557}
// *********************************************************************//
  IMiSelectableImage = interface(IDispatch)
    ['{F6379198-3B20-461A-B3A9-191945752557}']
    procedure CopyToClipboard(CopyAnnotation: Integer; AlwaysKeepAnnotationColor: Integer); safecall;
    function  ExportToPicture(CopyAnnotation: Integer; AlwaysKeepAnnotationColor: Integer): IPictureDisp; safecall;
    procedure GetBoundingRect(out plPageNum: Integer; out Left: Integer; out Top: Integer; 
                              out Right: Integer; out Bottom: Integer); safecall;
  end;

// *********************************************************************//
// DispIntf:  IMiSelectableImageDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {F6379198-3B20-461A-B3A9-191945752557}
// *********************************************************************//
  IMiSelectableImageDisp = dispinterface
    ['{F6379198-3B20-461A-B3A9-191945752557}']
    procedure CopyToClipboard(CopyAnnotation: Integer; AlwaysKeepAnnotationColor: Integer); dispid 1;
    function  ExportToPicture(CopyAnnotation: Integer; AlwaysKeepAnnotationColor: Integer): IPictureDisp; dispid 2;
    procedure GetBoundingRect(out plPageNum: Integer; out Left: Integer; out Top: Integer; 
                              out Right: Integer; out Bottom: Integer); dispid 3;
  end;

// *********************************************************************//
// Interface: IMiSearchCallback
// Flags:     (16) Hidden
// GUID:      {8376D508-78CA-416D-A903-2ED62E91E29B}
// *********************************************************************//
  IMiSearchCallback = interface(IUnknown)
    ['{8376D508-78CA-416D-A903-2ED62E91E29B}']
    function  IsCancelled(out pfIsCancel: Integer): HResult; stdcall;
  end;

// *********************************************************************//
// Interface: IMiDocView
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {F958524A-8422-4B07-B69E-199F2421ED89}
// *********************************************************************//
  IMiDocView = interface(IDispatch)
    ['{F958524A-8422-4B07-B69E-199F2421ED89}']
    function  Get_Document: IUnknown; safecall;
    procedure Set_Document(const pVal: IUnknown); safecall;
    function  Get_FileName: WideString; safecall;
    procedure Set_FileName(const pVal: WideString); safecall;
    function  Get_NumPages: Integer; safecall;
    procedure ClientToDocument(var plX: Integer; var plY: Integer); safecall;
    procedure DocumentToClient(var plX: Integer; var plY: Integer); safecall;
    procedure ClientToImage(lSX: Integer; lSY: Integer; out pnPage: Integer; out plX: Integer; 
                            out plY: Integer); safecall;
    procedure ImageToClient(nPage: Integer; lX: Integer; lY: Integer; out plSX: Integer; 
                            out plSY: Integer); safecall;
    procedure GetVisibleRect(out Left: Integer; out Top: Integer; out Right: Integer; 
                             out Bottom: Integer); safecall;
    procedure MoveRectIntoView(Left: Integer; Top: Integer; Right: Integer; Bottom: Integer); safecall;
    function  Get_DocViewMode: MiDocviewMode; safecall;
    procedure Set_DocViewMode(pVal: MiDocviewMode); safecall;
    function  Get_PageNum: Integer; safecall;
    procedure Set_PageNum(pVal: Integer); safecall;
    procedure GetScale(var pdScaleX: Double; var pdScaleY: Double); safecall;
    procedure SetScale(dScaleX: Double; dScaleY: Double); safecall;
    function  Get_FitMode: MiFITMODE; safecall;
    procedure Set_FitMode(pVal: MiFITMODE); safecall;
    function  Get_ActionState: MiActionState; safecall;
    procedure Set_ActionState(pVal: MiActionState); safecall;
    function  Get_TextSelection: IMiSelectableItem; safecall;
    procedure Set_TextSelection(const pVal: IMiSelectableItem); safecall;
    function  Get_ImageSelection: IMiSelectableImage; safecall;
    procedure Set_ImageSelection(const pVal: IMiSelectableImage); safecall;
    procedure SelectAll(nPage: Integer); safecall;
    procedure MoveSelectionToView(const pdispSelection: IDispatch); safecall;
    procedure Set_LayerVisible(Index: MiVIEWLAYER; pfVisible: WordBool); safecall;
    function  Get_LayerVisible(Index: MiVIEWLAYER): WordBool; safecall;
    property Document: IUnknown read Get_Document write Set_Document;
    property FileName: WideString read Get_FileName write Set_FileName;
    property NumPages: Integer read Get_NumPages;
    property DocViewMode: MiDocviewMode read Get_DocViewMode write Set_DocViewMode;
    property PageNum: Integer read Get_PageNum write Set_PageNum;
    property FitMode: MiFITMODE read Get_FitMode write Set_FitMode;
    property ActionState: MiActionState read Get_ActionState write Set_ActionState;
    property TextSelection: IMiSelectableItem read Get_TextSelection write Set_TextSelection;
    property ImageSelection: IMiSelectableImage read Get_ImageSelection write Set_ImageSelection;
    property LayerVisible[Index: MiVIEWLAYER]: WordBool read Get_LayerVisible write Set_LayerVisible;
  end;

// *********************************************************************//
// DispIntf:  IMiDocViewDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {F958524A-8422-4B07-B69E-199F2421ED89}
// *********************************************************************//
  IMiDocViewDisp = dispinterface
    ['{F958524A-8422-4B07-B69E-199F2421ED89}']
    property Document: IUnknown dispid 1;
    property FileName: WideString dispid 2;
    property NumPages: Integer readonly dispid 4;
    procedure ClientToDocument(var plX: Integer; var plY: Integer); dispid 48;
    procedure DocumentToClient(var plX: Integer; var plY: Integer); dispid 49;
    procedure ClientToImage(lSX: Integer; lSY: Integer; out pnPage: Integer; out plX: Integer; 
                            out plY: Integer); dispid 52;
    procedure ImageToClient(nPage: Integer; lX: Integer; lY: Integer; out plSX: Integer; 
                            out plSY: Integer); dispid 53;
    procedure GetVisibleRect(out Left: Integer; out Top: Integer; out Right: Integer; 
                             out Bottom: Integer); dispid 50;
    procedure MoveRectIntoView(Left: Integer; Top: Integer; Right: Integer; Bottom: Integer); dispid 51;
    property DocViewMode: MiDocviewMode dispid 23;
    property PageNum: Integer dispid 3;
    procedure GetScale(var pdScaleX: Double; var pdScaleY: Double); dispid 8;
    procedure SetScale(dScaleX: Double; dScaleY: Double); dispid 9;
    property FitMode: MiFITMODE dispid 10;
    property ActionState: MiActionState dispid 11;
    property TextSelection: IMiSelectableItem dispid 12;
    property ImageSelection: IMiSelectableImage dispid 47;
    procedure SelectAll(nPage: Integer); dispid 33;
    procedure MoveSelectionToView(const pdispSelection: IDispatch); dispid 13;
    property LayerVisible[Index: MiVIEWLAYER]: WordBool dispid 29;
  end;

// *********************************************************************//
// DispIntf:  _IMiDocViewEvents
// Flags:     (4096) Dispatchable
// GUID:      {9028B775-EC59-4118-862A-EFDEAF5955A4}
// *********************************************************************//
  _IMiDocViewEvents = dispinterface
    ['{9028B775-EC59-4118-862A-EFDEAF5955A4}']
    procedure FitmodeChanged; dispid 1;
    procedure ScaleChanged; dispid 2;
    procedure SelectionChanged; dispid 3;
    procedure PageChanged; dispid 4;
    procedure PageCountChanged; dispid 5;
    procedure CurPageNumChanged; dispid 6;
    procedure VisibleRectChanged; dispid 7;
  end;

// *********************************************************************//
// Interface: IMiDocSearch
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {BC06ED64-A40C-4FB4-A660-AC6DBC752292}
// *********************************************************************//
  IMiDocSearch = interface(IDispatch)
    ['{BC06ED64-A40C-4FB4-A660-AC6DBC752292}']
    procedure Initialize(const piDoc: IUnknown; const strPattern: WideString;
                         var PageNum: OleVariant; var WordIndex: OleVariant; 
                         var StartAfterIndex: OleVariant; var Backward: OleVariant; 
                         MatchMinus: WordBool; MatchFullHalfWidthForm: WordBool; 
                         MatchHiraganaKatakana: WordBool; IgnoreSpace: WordBool); safecall;
    procedure Search(const pSearchCallback: IMiSearchCallback; 
                     var ppiSearchResult: IMiSelectableItem); safecall;
  end;

// *********************************************************************//
// DispIntf:  IMiDocSearchDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {BC06ED64-A40C-4FB4-A660-AC6DBC752292}
// *********************************************************************//
  IMiDocSearchDisp = dispinterface
    ['{BC06ED64-A40C-4FB4-A660-AC6DBC752292}']
    procedure Initialize(const piDoc: IUnknown; const strPattern: WideString;
                         var PageNum: OleVariant; var WordIndex: OleVariant;
                         var StartAfterIndex: OleVariant; var Backward: OleVariant;
                         MatchMinus: WordBool; MatchFullHalfWidthForm: WordBool;
                         MatchHiraganaKatakana: WordBool; IgnoreSpace: WordBool); dispid 1;
    procedure Search(const pSearchCallback: IMiSearchCallback;
                     var ppiSearchResult: IMiSelectableItem); dispid 2;
  end;

implementation

end.
