program imgtotxt;

{$APPTYPE CONSOLE}

uses
  Classes, ComObj, MODI_TLB, ActiveX;

{$R *.res}

const
 MODIDoc='MODI.Document';
var
 imgfn:string[254];
 txtfn:string[254];

function AppIsInstalled(const strOLEObject:string):Boolean;
var
 ClassID:TCLSID;
begin
 Result:=(CLSIDFromProgID(PWideChar(WideString(strOLEObject)),ClassID)=S_OK)
end;

function ImgToText(const imgfn,txtfn:string):integer;
var
 doc:IDocument;
 Img:IImage;
 Layout:ILayout;
 GUID:TGUID;
 f:TFileStream;
 s:string;
begin
 try
  f:=TFileStream.Create(txtfn,fmCreate);
 except
  writeln('    ');
  Result:=-5;
  exit;
 end;
 if not AppIsInstalled(MODIDoc) then
  begin
   writeln('  MODI');
   f.Free;
   Result:=-1;
   exit;
  end;
 CoInitialize(nil);
 CLSIDFromProgID(MODIDoc,GUID);
 try
  doc := CreateComObject(GUID) as IDocument;
 except
  writeln(' ');
  f.Free;
  Result:=-2;
  exit;
 end;
 try Doc.Create(''); except; end;
 try
  doc.create(ImgFn);
 except
  writeln('  ');
  f.Free;
  Result:=-3;
  exit;
 end;
 try
  doc.ocr(miLANG_RUSSIAN,true,true);
 except
  writeln('  ');
  doc:=nil;
  f.Free;
  Result:=-4;
  exit;
 end;
 try
  Img := doc.Images[0] as IImage;
 except
  writeln('  ');
  f.Free;
  Result:=-3;
  exit;
 end;
 try
  Layout := Img.Layout;
  if Layout.NumWords>0 then
   s:=Layout.Text
  else
   s:=''; 
 except
  Layout:=nil;
  doc:=nil;
  Img:=nil;
  writeln('  ');
  f.Free;
  Result:=-4;
  exit;
 end;
 try
  doc.Close(false);
 except
  doc:=nil;
 end;
 Img:=nil;
 Layout:=nil;
 doc:=nil;
 try
  if length(s)>0 then
   f.WriteBuffer(s[1],length(s));
 except
  writeln('    ');
  f.Free;
  Result:=-5;
  exit;
 end;
 f.Free;
 Result:=0;
end;

begin
 if ParamCount<>2 then
  begin
   writeln('Usage: imgtotxt.exe imagefile.ext outputfile.txt');
   ExitCode:=-10;
   exit;
  end;
 imgfn:=Paramstr(1);
 txtfn:=Paramstr(2);
 ExitCode:=ImgToText(imgfn,txtfn);
end.
