program mditotif;

{$APPTYPE CONSOLE}

uses
  Classes, ComObj, modi11, ActiveX, SysUtils;

{$R *.res}

const
 MODIDoc='MODI.Document';
var
 mdifn:string[254];
 tiffn:string[254];

function AppIsInstalled(const strOLEObject:string):Boolean;
var
 ClassID:TCLSID;
begin
 Result:=(CLSIDFromProgID(PWideChar(WideString(strOLEObject)),ClassID)=S_OK)
end;

function MdiToTifFunc(const mdifn,tiffn:string):integer;
var
 doc:IDocument;
 GUID:TGUID;
begin
 if not AppIsInstalled(MODIDoc) then
  begin
   writeln('  MODI');
   Result:=-1;
   exit;
  end;
 CoInitialize(nil);
 CLSIDFromProgID(MODIDoc,GUID);
 try
  doc := CreateComObject(GUID) as IDocument;
 except
  on E:Exception do
   begin
    writeln(' . '+E.Message);
    Result:=-2;
    exit;
   end;
 end;
 try Doc.Create(''); except; end;
 try
  doc.create(MdiFn);
 except
  on E:Exception do
   begin
    writeln('  . '+E.Message);
    Result:=-3;
    exit;
   end;
 end;
 try
  doc.SaveAs(TifFn,miFILE_FORMAT_TIFF,miCOMP_LEVEL_HIGH);
 except
  on E:Exception do
   begin
    writeln('  . '+E.Message);
    doc:=nil;
    Result:=-4;
    exit;
   end;
 end;
 try
  doc.Close(false);
 except
  doc:=nil;
 end;
 Result:=0;
end;

begin
 if ParamCount<>2 then
  begin
   writeln('Usage: mditotif.exe inputfile.mdi outputfile.tif');
   ExitCode:=-10;
   exit;
  end;
 mdifn:=Paramstr(1);
 tiffn:=Paramstr(2);
 ExitCode:=MdiToTifFunc(mdifn,tiffn);
end.
