unit PDFUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtrls, StdCtrls, ExtCtrls, ComCtrls, JPEG;

type
  TPdfToJpgForm = class(TForm)
    TopPanel: TPanel;
    LogMemo: TMemo;
    ConvertButton: TButton;
    FileNameLabel: TLabel;
    FileNameEdit: TEdit;
    MyProgressBar: TProgressBar;
    PDFOpenDialog: TOpenDialog;
    StopButton: TButton;
    procedure ConvertButtonClick(Sender: TObject);
    procedure FileNameEditDblClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
   StopFlag:boolean;
    { Public declarations }
  end;

var
  PdfToJpgForm: TPdfToJpgForm;

implementation

uses PrnUnit, PdfPage, AcroPDFLib_TLB, PDFLib_TLB, TlHelp32;

{$R *.dfm}

type
 st255=string[255];
 st80=string[80];
 TWND=record
  Hwnd:DWORD;
  ClassName:st255;
  WindowText:string;
 end;

const
 BlockSize=400;
 BlockCount=6;
 MaxSize=BlockSize*BlockCount;

 WaitPause=1000;
 SleepPause=150;
 StartPause=100;
 CycleCount=100;
var
 ChildWindowCount:integer;
 ChildWindows:array of TWnd;
 AdobeThread:THandle;

const
 THREAD_TERMINATE = $0001;
 THREAD_SUSPEND_RESUME = $0002;
 THREAD_GET_CONTEXT = $0008;
 THREAD_SET_CONTEXT = $0010;
 THREAD_SET_INFORMATION = $0020;
 THREAD_QUERY_INFORMATION = $0040;
 THREAD_SET_THREAD_TOKEN = $0080;
 THREAD_IMPERSONATE = $0100;
 THREAD_DIRECT_IMPERSONATION = $0200;
 THREAD_SET_LIMITED_INFORMATION = $0400;
 THREAD_QUERY_LIMITED_INFORMATION = $0800;
 THREAD_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or $03FF;
 ThreadQuerySetWin32StartAddress=9;

function OpenThread(dwDesiredAccess: DWord; bInheritHandle: Bool; dwThreadId: DWord): DWord; stdcall; external 'kernel32.dll';

{function NtQueryInformationThread(
    ThreadHandle: DWORD;
    ThreadInformationClass: DWORD;
    ThreadInformation: Pointer;
    ThreadInformationLength: DWORD;
    ReturnLength: DWORD): DWORD; stdcall; external 'ntdll.dll';
type
  PTHREAD_BASIC_INFORMATION = ^THREAD_BASIC_INFORMATION;
  THREAD_BASIC_INFORMATION = record // Information Class 0
    ExitStatus: bool;
    TebBaseAddress: pointer;
    UniqueProcess: DWORD;
    UniqueThread: DWORD;
    AffinityMask: DWORD;
    Priority: DWORD;
    BasePriority: DWORD;
  end;

function GetThreadStartAddress(ThreadHandle:THandle):DWORD;
var
 dwThreadStartAddr:DWORD;
 PeusdoCurrentProcessHandle,NewThreadHandle:DWORD;
 ntStatus:DWORD;
begin
 dwThreadStartAddr:=0;
 PeusdoCurrentProcessHandle:=GetCurrentProcess;
 if DuplicateHandle(PeusdoCurrentProcessHandle, ThreadHandle, PeusdoCurrentProcessHandle, @NewThreadHandle, THREAD_QUERY_INFORMATION, FALSE, 0) then
  begin
   ntStatus:=NtQueryInformationThread(NewThreadHandle, ThreadQuerySetWin32StartAddress, @dwThreadStartAddr, sizeof(DWORD), 0);
   if(ntStatus <> 0) then Result:=0 else Result:=dwThreadStartAddr;
   CloseHandle(NewThreadHandle);
  end
 else Result:=0;
end;       }

function GetTime(ThreadHandle:THandle):DWORD;
var
  KernelTime : TFileTime;
  UserTime : TFileTime;
  Dummy1, Dummy2 : TFileTime;
begin
  Result:=0;
  if GetThreadTimes(ThreadHandle, Dummy1, Dummy2, KernelTime, UserTime) then
   Result:=UserTime.dwLowDateTime;
end;
{
function GetAdobeThreadTime(dwOwnerPID:DWORD):DWORD;
type
 TTH=record
  tid:THandle;
  tim:DWORD;
  baseaddr:DWORD;
 end;
var
 hModuleSnap,hThreadSnap:Thandle;
 te32:THREADENTRY32;
 tp32:MODULEENTRY32;
 th:array of TTH;
 i,tcnt,h:integer;
begin
 Result:=0;
 hThreadSnap:=CreateToolhelp32Snapshot(TH32CS_SNAPTHREAD, dwOwnerPID);
 if (hThreadSnap=THandle(-1)) then exit;
 tcnt:=0;
 SetLength(th,tcnt);
 te32.dwSize:=sizeof(THREADENTRY32);
 te32.cntUsage:= 0;
 if (Thread32First(hThreadSnap, te32)) then
  repeat
   if te32.th32OwnerProcessID=dwOwnerPID then
    begin
     inc(tcnt);
     SetLength(th,tcnt);
     th[tcnt-1].tid:=te32.th32ThreadID;
     h:=OpenThread(THREAD_ALL_ACCESS, False, th[tcnt-1].tid);
     th[tcnt-1].tim:=GetTime(h);
     th[tcnt-1].baseaddr:=GetThreadStartAddress(h);
     CloseHandle(h);
    end;
  until not(Thread32Next(hThreadSnap, te32));
 CloseHandle (hThreadSnap);
 hModuleSnap:=CreateToolhelp32Snapshot(TH32CS_SNAPMODULE, dwOwnerPID);
 tp32.dwSize:=sizeof(MODULEENTRY32);
 if (Module32First(hModuleSnap, tp32)) then
  repeat
   if tp32.th32ProcessID=dwOwnerPID then
   if AnsiUpperCase(tp32.szModule)=AnsiUpperCase('AcroRd32.dll') then
    for i:=1 to tcnt do
    if (th[tcnt-1].baseaddr>=DWORD(tp32.modBaseAddr)) and (th[i-1].baseaddr<=DWORD(tp32.modBaseAddr)+tp32.modBaseSize) then
    if (th[tcnt-1].tim>0) then
     Result:=Result+th[tcnt-1].tim;
 until not(Module32Next(hModuleSnap, tp32));
 CloseHandle (hModuleSnap);
end;}

function EnumChildWndProc(Handle: HWND; l: lparam): Bool; stdcall;
var
 clss:array[0..254] of char;
 desc:array[0..254] of char;
 r:DWORD;
begin
 Result := True;
 SendMessageTimeout(Handle, WM_GETTEXT, 254, LongInt(@desc), SMTO_ABORTIFHUNG, WaitPause, r);
 GetClassName(Handle, clss, SizeOf(clss) - 1);
 Inc(ChildWindowCount);
 SetLength(ChildWindows,ChildWindowCount);
 with ChildWindows[ChildWindowCount-1] do
  begin
   Hwnd:=Handle;
   ClassName:=String(clss);
   WindowText:=String(desc);
   PDFToJPGForm.LogMemo.Lines.Add(String(clss)+':'+String(desc));
  end;
end;

{     }
procedure GetChildWindows(H:HWND);
begin
 ChildWindowCount:=0;
 EnumChildWindows(H,@EnumChildWndProc,0);
end;

procedure Delay(msecs: dword);
var
 FirstTickCount: dword;
begin { Delay }
 FirstTickCount:=GetTickCount;
 repeat
  Application.ProcessMessages; {allowing access to other controls, etc.}
 until ((GetTickCount-FirstTickCount)>=msecs);
end; { Delay }

function SetClientRect(h:HWND;rect:TRect):boolean;
begin
 Result:=MoveWindow(h, rect.left, rect.top, rect.right-rect.left,rect.bottom-rect.top, TRUE);
 UpdateWindow(h);
end;

const
 WaitRenderingCycleCount=1000;
 PicSize=100;

function PrintWindow(hwnd: HWND; hdcBlt: HDC; nFlags: UINT): BOOL; stdcall; external user32;

function PrnWnd(h:THandle;var b:TBitmap):boolean;
var
 i,j,k:integer;
 p:PChar;
 w:DWORD;
begin
 Result:=false;
 for k:=1 to WaitRenderingCycleCount do
  begin
   w:=GetWindowLong(PrnForm.Handle,GWL_STYLE);
   if (w and WS_VISIBLE<>WS_VISIBLE) or (w and WS_MINIMIZE=WS_MINIMIZE) then
    SHOWWINDOW(PrnForm.Handle,SW_SHOWNORMAL);
   PrintWindow(h,b.Canvas.Handle,0);
   for i:=0 to PicSize-1 do
    begin
     p:=PChar(b.ScanLine[i]);
     for j:=0 to PicSize*3-1 do
      if (p[0]<>#0) then begin Result:=true; exit; end;
     Application.ProcessMessages;
     if PdfToJPGForm.StopFlag then exit;
    end;
  end;
end;

procedure TPdfToJpgForm.ConvertButtonClick(Sender: TObject);
var
 i,j,k,l,h,hp,hp1:integer;
 p,pid,tid:cardinal;
 m,n:integer;
 r,r1,dr,sr:Trect;
 tBmp, BmpResult, b: TBitmap;
 JP:TJPegImage;
 cx,cy:integer;
 sl:PChar;
 t1,t2,t3,t4:DWORD;
 pc:integer;
 s:string;
 v:integer;
 cr,cg,cb:char;
 winLong:LongInt;
 dC:HDC;
 x,z:boolean;
 pp:PChar;
 y:boolean;
label
 EndLabel;
begin
 if ver=0 then begin ShowMessage('  Adobe Reader!'); exit; end;
 if not FileExists(FileNameEdit.Text) then begin ShowMessage('     !'); exit; end;
 AdobeThread:=0;
 {     }
 pc:=GetPDFPageCount(FileNameEdit.Text);
 ConvertButton.Enabled:=false;
 StopButton.Enabled:=true;
 if ver=2 then
  begin
   PDF2.Width:=MaxSize+9;
   PDF2.Height:=MaxSize+9;
  end
 else
  begin
   PDF1.Width:=MaxSize+9;
   PDF1.Height:=MaxSize+9;
  end;
 PDFToJPGForm.LogMemo.Lines.Add('Start '+DateTimeToStr(Now)+'. Load File');
 if ver=2 then
  PDF2.LoadFile(FileNameEdit.Text)
 else
  PDF1.LoadFile(FileNameEdit.Text);
{      AVPageView }
 for j:=0 to CycleCount do
 begin
  Delay(SleepPause);
  h:=0;
  ChildWindowCount:=0;
  if ver=2 then
   GetChildWindows(PDF2.Handle)
  else
   GetChildWindows(PDF1.Handle);
  for i:=1 to ChildWindowCount do
   if AnsiUpperCase(ChildWindows[i-1].WindowText)='AVPAGEVIEW' THEN
    begin
     h:=i;
     break;
    end;
  if h>0 then break;
 end;
 if h=0 then begin ShowMessage('  Adobe Reader'); goto EndLabel; end;
 tid:=GetWindowThreadProcessId(ChildWindows[h-1].Hwnd,pid);
 AdobeThread:=OpenThread(THREAD_ALL_ACCESS, False, tid);
 JP:=TJpegImage.Create;
{   PDF }
 t1:=GetTime(AdobeThread);
 if ver=2 then
  begin
   PDF2.SetLayoutMode('SinglePage');
   PDF2.setPageMode('none');
   PDF2.setShowToolbar(false);
   PDF2.setShowScrollbars(false);
   PDF2.setView('Fit');
   PDF2.gotoFirstPage;
   SendMessage(ChildWindows[h-1].Hwnd,WM_CHAR,27,0);
  end
 else
  begin
   PDF1.SetLayoutMode('SinglePage');
   PDF1.setPageMode('none');
   PDF1.setShowToolbar(false);
   PDF1.setShowScrollbars(false);
   PDF1.setView('Fit');
   PDF1.gotoFirstPage;
  end;
 repeat
  Delay(SleepPause);
  t2:=GetTime(AdobeThread);
  if (t2=t1)then break;
  t1:=t2;
  if StopFlag then break;
 until false;
{   }
 tBmp := TBitmap.Create;
 tBmp.PixelFormat:=pf24bit;
 BmpResult:=TBitmap.Create;
 BmpResult.PixelFormat:=pf24bit;
 b:=TBitmap.Create;
 b.PixelFormat:=pf24bit;
 MyProgressBar.Max:=BlockCount*BlockCount;
{  Adobe Reader }
 if ver=2 then
  try s:=PDF2.GetVersions;
  except s:=''; end
 else
  s:='';
 i:=Pos('=',s);
 if i=0 then v:=5 else
 try v:=strtoint(s[i+1]);
  if v=1 then
   v:=v*10+strtoint(s[i+2]);
 except v:=5; end;
 Delay(StartPause);
 PDFToJPGForm.LogMemo.Lines.Add(s);
 if v<7 then
  hp1:=GetParent(ChildWindows[h-1].Hwnd)
 else
  hp1:=ChildWindows[h-1].Hwnd;
 hp:=GetParent(hp1);
 tBmp.Width:=BlockSize+4;
 tBmp.Height:=BlockSize+4;
 {    }
 for m:=1 to pc do
  begin
   Windows.GetClientRect(hp1,r1);
   Delay(SleepPause);
   if ver=2 then
    if v<9 then
     begin
      r:=Rect(0,0,BlockSize+84,BlockSize+84);
      SetClientRect(PDF2.Handle,r)
     end
    else
     begin
      r:=Rect(0,0,BlockSize+4,BlockSize+4);
      SetClientRect(hp,r);
     end;
   SetClientRect(hp1,r1);
   if v=10 then
    BmpResult.Width:=r1.Right-9
   else
    BmpResult.Width:=r1.Right;
   BmpResult.Height:=r1.Bottom-9;
   PDFToJPGForm.LogMemo.Lines.Add('Start '+DateTimeToStr(Now)+'. Convert '+IntToStr(m)+' of '+IntToStr(pc)+' page');
   {  Rendering   }
   if v>=8 then
   for i:=1 to BlockCount do
    begin
    for j:=1 to BlockCount do
     begin
      SetClientRect(hp1,Rect(r1.Left-(i-1)*BlockSize,r1.Top-(j-1)*BlockSize,r1.Right-(i-1)*BlockSize,r1.Bottom-(j-1)*BlockSize));
      PrnWnd(PrnForm.Handle,tbmp);
      if PdfToJPGForm.StopFlag then break;
     end;
      if StopFlag then break;
    end;
   {     }
   t3:=0;
   for i:=1 to BlockCount do
    begin
     for j:=1 to BlockCount do
      begin
       y:=t3<>t1;
       t1:=GetTime(AdobeThread);
       t3:=t1;
   {   t3:=GetAdobeThreadTime(pid);}
       SetClientRect(hp1,Rect(r1.Left-(i-1)*BlockSize,r1.Top-(j-1)*BlockSize,r1.Right-(i-1)*BlockSize,r1.Bottom-(j-1)*BlockSize));
       { ,    }
       if v<9 then PrnWnd(hp,tBmp);
       repeat
        if v>=9 then PrnWnd(hp,tBmp);
        if y then Delay(SleepPause) else Delay(1);
        t2:=GetTime(AdobeThread);
   {    t4:=GetAdobeThreadTime(pid);}
        if (t2=t1) {and (t4=t3) } then break;
        t1:=t2; { t3:=t4; }
        if StopFlag then break;
       until false;
       if StopFlag then break;
       PrnWnd(hp,tBmp);
       if j=1 then
        begin
         dr:=Rect((i-1)*BlockSize,(j-1)*BlockSize,i*BlockSize,j*BlockSize-4);
         sr:=Rect(0,4,BlockSize,BlockSize);
        end
       else
        if j=BlockCount then
         begin
          dr:=Rect((i-1)*BlockSize,(j-1)*BlockSize-4,i*BlockSize,j*BlockSize);
          sr:=Rect(0,0,BlockSize,BlockSize+4);
         end
        else
         begin
          dr:=Rect((i-1)*BlockSize,(j-1)*BlockSize-4,i*BlockSize,j*BlockSize-4);
          sr:=Rect(0,0,BlockSize,BlockSize);
         end;
       BitBlt(BmpResult.Canvas.Handle,dr.Left,dr.Top,dr.Right-dr.Left,dr.Bottom-dr.Top,tbmp.Canvas.Handle,sr.Left,sr.Top,SRCCOPY);
       MyProgressBar.Position:=(i-1)*BlockCount+j;
      end;
     if StopFlag then break;
    end;
   if StopFlag then
    begin
     PDFToJPGForm.LogMemo.Lines.Add('Cancel convert '+DateTimeToStr(Now));
     break;
    end;
   cx:=BmpResult.Width div 2;
   cy:=BmpResult.Height div 2;
   i:=0;
   cr:=PChar(BmpResult.ScanLine[BmpResult.Height-1])[2];
   cg:=PChar(BmpResult.ScanLine[BmpResult.Height-1])[1];
   cb:=PChar(BmpResult.ScanLine[BmpResult.Height-1])[0];
{   case v of
    7: begin cr:=#170; cg:=#168; cb:=#164; end;
    8: begin cr:=#103; cg:=#103; cb:=#103; end;
    9: begin cr:=#51; cg:=#51; cb:=#51; end;
   else begin cr:=#51; cg:=#51; cb:=#51; end;
   end;}
  { cropping image }
   repeat
    sl:=PChar(BmpResult.ScanLine[i])+cx*3;
    inc(i);
   until not((sl[0]=cb) and (sl[1]=cg) and (sl[2]=cr) and (i<cy));
   r.Top:=i-1;
   i:=BmpResult.Height;
   repeat
    dec(i);
    sl:=PChar(BmpResult.ScanLine[i])+cx*3;
   until not((sl[0]=cb) and (sl[1]=cg) and (sl[2]=cr) and (i>cy));
   r.Bottom:=i+1;
   sl:=PChar(BmpResult.ScanLine[cy]);
   i:=0;
   repeat
    inc(i);
   until not((sl[i*3]=cb) and (sl[i*3+1]=cg) and (sl[i*3+2]=cr) and (i<cx));
   r.Left:=i-1;
   i:=BmpResult.Width;
   repeat
    dec(i);
   until not((sl[i*3]=cb) and (sl[i*3+1]=cg) and (sl[i*3+2]=cr) and (i>cx));
   r.Right:=i+1;
   b.Width:=r.Right-r.Left;
   b.Height:=r.Bottom-r.Top;
   b.Dormant;
   b.PixelFormat:=pf24bit;
   BitBlt(b.Canvas.Handle,0,0,b.Width,b.Height,BmpResult.Canvas.Handle,r.Left,r.Top,SRCCOPY);
   Jp.Assign(b);
   Jp.SaveToFile(ExtractFilePath(FileNameEdit.Text)+'\result_'+inttostr(m)+'.jpg');
//   b.SaveToFile(ExtractFilePath(FileNameEdit.Text)+'\result_'+inttostr(m)+'.bmp');
   if ver=2 then
    PDF2.gotoNextPage
   else
    PDF1.gotoNextPage;
  end;
 tBmp.Free;
 BmpResult.Free;
 b.Free;
EndLabel:
 PDFToJPGForm.LogMemo.Lines.Add('Stop '+DateTimeToStr(Now));
 MyProgressBar.Position:=0;
 StopFlag:=false;
 StopButton.Enabled:=false;
 ConvertButton.Enabled:=true;
 if AdobeThread>0 then
  CloseHandle(AdobeThread);
{   p:=OpenProcess(PROCESS_TERMINATE,false,pid);
   TerminateProcess(p,0);
   CloseHandle(p);}
end;

procedure TPdfToJpgForm.FileNameEditDblClick(Sender: TObject);
begin
 PDFOpenDialog.FileName:=FileNameEdit.Text;
 PDFOpenDialog.InitialDir:=ExtractFilePath(FileNameEdit.Text);
 if PDFOpenDialog.Execute then
  begin
   FileNameEdit.Text:=PDFOpenDialog.FileName;
  end;
end;

procedure TPdfToJpgForm.StopButtonClick(Sender: TObject);
begin
 StopFlag:=true;
end;

procedure TPdfToJpgForm.FormActivate(Sender: TObject);
begin
 AdobeThread:=0;
 StopFlag:=false;
end;

end.

