unit PdfLib_TLB;

{$TYPEDADDRESS OFF} // Unit must be compiled without type-checked pointers.
{$WARN SYMBOL_PLATFORM OFF}
{$WRITEABLECONST ON}
{$VARPROPSETTER ON}
interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, OleServer, StdVCL, Variants;

const
  // TypeLibrary Major and minor versions
  PdfLibMajorVersion = 1;
  PdfLibMinorVersion = 3;

  LIBID_PdfLib: TGUID = '{CA8A9783-280D-11CF-A24D-444553540000}';

  DIID__DPdf: TGUID = '{CA8A9781-280D-11CF-A24D-444553540000}';
  DIID__DPdfEvents: TGUID = '{CA8A9782-280D-11CF-A24D-444553540000}';
  CLASS_Pdf: TGUID = '{CA8A9780-280D-11CF-A24D-444553540000}';
type

  _DPdf = dispinterface;
  _DPdfEvents = dispinterface;

  Pdf = _DPdf;


  _DPdf = dispinterface
    ['{CA8A9781-280D-11CF-A24D-444553540000}']
    property src: WideString dispid 1;
    function LoadFile(const fileName: WideString): WordBool; dispid 2;
    procedure setShowToolbar(On_: WordBool); dispid 3;
    procedure gotoFirstPage; dispid 4;
    procedure gotoLastPage; dispid 5;
    procedure gotoNextPage; dispid 6;
    procedure gotoPreviousPage; dispid 7;
    procedure setCurrentPage(n: Integer); dispid 8;
    procedure goForwardStack; dispid 9;
    procedure goBackwardStack; dispid 10;
    procedure setPageMode(const pageMode: WideString); dispid 11;
    procedure setLayoutMode(const layoutMode: WideString); dispid 12;
    procedure setNamedDest(const namedDest: WideString); dispid 13;
    procedure Print; dispid 14;
    procedure printWithDialog; dispid 15;
    procedure setZoom(percent: Single); dispid 16;
    procedure setZoomScroll(percent: Single; left: Single; top: Single); dispid 17;
    procedure setView(const viewMode: WideString); dispid 18;
    procedure setViewScroll(const viewMode: WideString; offset: Single); dispid 19;
    procedure setViewRect(left: Single; top: Single; width: Single; height: Single); dispid 20;
    procedure printPages(from: Integer; to_: Integer); dispid 21;
    procedure printPagesFit(from: Integer; to_: Integer; shrinkToFit: WordBool); dispid 22;
    procedure printAll; dispid 23;
    procedure printAllFit(shrinkToFit: WordBool); dispid 24;
    procedure setShowScrollbars(On_: WordBool); dispid 25;
    procedure AboutBox; dispid -552;
  end;

  _DPdfEvents = dispinterface
    ['{CA8A9782-280D-11CF-A24D-444553540000}']
  end;

  TPdf = class(TOleControl)
  private
    FIntf: _DPdf;
    function  GetControlInterface: _DPdf;
  protected
    procedure CreateControl;
    procedure InitControlData; override;
  public
    function LoadFile(const fileName: WideString): WordBool;
    procedure setShowToolbar(On_: WordBool);
    procedure gotoFirstPage;
    procedure gotoLastPage;
    procedure gotoNextPage;
    procedure gotoPreviousPage;
    procedure setCurrentPage(n: Integer);
    procedure goForwardStack;
    procedure goBackwardStack;
    procedure setPageMode(const pageMode: WideString);
    procedure setLayoutMode(const layoutMode: WideString);
    procedure setNamedDest(const namedDest: WideString);
    procedure Print;
    procedure printWithDialog;
    procedure setZoom(percent: Single);
    procedure setZoomScroll(percent: Single; left: Single; top: Single);
    procedure setView(const viewMode: WideString);
    procedure setViewScroll(const viewMode: WideString; offset: Single);
    procedure setViewRect(left: Single; top: Single; width: Single; height: Single);
    procedure printPages(from: Integer; to_: Integer);
    procedure printPagesFit(from: Integer; to_: Integer; shrinkToFit: WordBool);
    procedure printAll;
    procedure printAllFit(shrinkToFit: WordBool);
    procedure setShowScrollbars(On_: WordBool);
    procedure AboutBox;
    property  ControlInterface: _DPdf read GetControlInterface;
    property  DefaultInterface: _DPdf read GetControlInterface;
  published
    property  TabStop;
    property  Align;
    property  DragCursor;
    property  DragMode;
    property  ParentShowHint;
    property  PopupMenu;
    property  ShowHint;
    property  TabOrder;
    property  Visible;
    property  OnDragDrop;
    property  OnDragOver;
    property  OnEndDrag;
    property  OnEnter;
    property  OnExit;
    property  OnStartDrag;
    property src: WideString index 1 read GetWideStringProp write SetWideStringProp stored False;
  end;

procedure Register;

resourcestring
  dtlServerPage = 'ActiveX';

implementation

uses ComObj;

procedure TPdf.InitControlData;
const
  CControlData: TControlData2 = (
    ClassID: '{CA8A9780-280D-11CF-A24D-444553540000}';
    EventIID: '';
    EventCount: 0;
    EventDispIDs: nil;
    LicenseKey: nil (*HR:$80004005*);
    Flags: $00000000;
    Version: 401);
begin
  ControlData := @CControlData;
end;

procedure TPdf.CreateControl;

  procedure DoCreate;
  begin
    FIntf := IUnknown(OleObject) as _DPdf;
  end;

begin
  if FIntf = nil then DoCreate;
end;

function TPdf.GetControlInterface: _DPdf;
begin
  CreateControl;
  Result := FIntf;
end;

function TPdf.LoadFile(const fileName: WideString): WordBool;
begin
  Result := DefaultInterface.LoadFile(fileName);
end;

procedure TPdf.setShowToolbar(On_: WordBool);
begin
  DefaultInterface.setShowToolbar(On_);
end;

procedure TPdf.gotoFirstPage;
begin
  DefaultInterface.gotoFirstPage;
end;

procedure TPdf.gotoLastPage;
begin
  DefaultInterface.gotoLastPage;
end;

procedure TPdf.gotoNextPage;
begin
  DefaultInterface.gotoNextPage;
end;

procedure TPdf.gotoPreviousPage;
begin
  DefaultInterface.gotoPreviousPage;
end;

procedure TPdf.setCurrentPage(n: Integer);
begin
  DefaultInterface.setCurrentPage(n);
end;

procedure TPdf.goForwardStack;
begin
  DefaultInterface.goForwardStack;
end;

procedure TPdf.goBackwardStack;
begin
  DefaultInterface.goBackwardStack;
end;

procedure TPdf.setPageMode(const pageMode: WideString);
begin
  DefaultInterface.setPageMode(pageMode);
end;

procedure TPdf.setLayoutMode(const layoutMode: WideString);
begin
  DefaultInterface.setLayoutMode(layoutMode);
end;

procedure TPdf.setNamedDest(const namedDest: WideString);
begin
  DefaultInterface.setNamedDest(namedDest);
end;

procedure TPdf.Print;
begin
  DefaultInterface.Print;
end;

procedure TPdf.printWithDialog;
begin
  DefaultInterface.printWithDialog;
end;

procedure TPdf.setZoom(percent: Single);
begin
  DefaultInterface.setZoom(percent);
end;

procedure TPdf.setZoomScroll(percent: Single; left: Single; top: Single);
begin
  DefaultInterface.setZoomScroll(percent, left, top);
end;

procedure TPdf.setView(const viewMode: WideString);
begin
  DefaultInterface.setView(viewMode);
end;

procedure TPdf.setViewScroll(const viewMode: WideString; offset: Single);
begin
  DefaultInterface.setViewScroll(viewMode, offset);
end;

procedure TPdf.setViewRect(left: Single; top: Single; width: Single; height: Single);
begin
  DefaultInterface.setViewRect(left, top, width, height);
end;

procedure TPdf.printPages(from: Integer; to_: Integer);
begin
  DefaultInterface.printPages(from, to_);
end;

procedure TPdf.printPagesFit(from: Integer; to_: Integer; shrinkToFit: WordBool);
begin
  DefaultInterface.printPagesFit(from, to_, shrinkToFit);
end;

procedure TPdf.printAll;
begin
  DefaultInterface.printAll;
end;

procedure TPdf.printAllFit(shrinkToFit: WordBool);
begin
  DefaultInterface.printAllFit(shrinkToFit);
end;

procedure TPdf.setShowScrollbars(On_: WordBool);
begin
  DefaultInterface.setShowScrollbars(On_);
end;

procedure TPdf.AboutBox;
begin
  DefaultInterface.AboutBox;
end;

procedure Register;
begin
  RegisterComponents('ActiveX',[TPdf]);
end;

end.
