unit PrnUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, AcroPDFLib_TLB, PDFLib_TLB;

type
  TPrnForm = class(TForm)
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PrnForm: TPrnForm;
  PDF1:TPDF;
  PDF2:TAcroPDF;
  ver:integer;

implementation

uses PDFUnit;

{$R *.dfm}

procedure TPrnForm.FormDestroy(Sender: TObject);
begin
 if ver=2 then
  PDF2.Free
 else
  if ver=1 then
   PDF1.Free;
end;

procedure TPrnForm.FormCreate(Sender: TObject);
var
 n:Cardinal;
begin
 try
  PDF2:=TAcroPDF.Create(PrnForm);
  PDF2.Parent:=PrnForm;
  PDF2.Left:=0;
  PDF2.Top:=0;
  n:=GetWindowLong(PDF2.Handle,GWL_STYLE) OR WS_DISABLED;
  SetWindowLong(PDF2.Handle,GWL_STYLE,n);
  PDF2.GetVersions;
  ver:=2;
 except
  if Assigned(PDF2) then PDF2.Free;
  try
   PDF1:=TPDF.Create(PrnForm);
   PDF1.Parent:=PrnForm;
   PDF1.Left:=0;
   PDF1.Top:=0;
   n:=GetWindowLong(PDF1.Handle,GWL_STYLE) OR WS_DISABLED;
   SetWindowLong(PDF1.Handle,GWL_STYLE,n);
   ver:=1;
  except
   ver:=0;
   ShowMessage('  Adobe Reader');
  end;
 end;
end;

end.
