unit prnsecu;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleServer, WbemScripting_TLB, StdCtrls, ActiveX, ComCtrls,
  CheckLst, CommCtrl, Menus;

type
  TMainForm = class(TForm)
    GetButton: TButton;
    PrnCheckListBox: TCheckListBox;
    SetOwnerButton: TButton;
    SetGrantButton: TButton;
    MainPopupMenu: TPopupMenu;
    MainProgressBar: TProgressBar;
    N1: TMenuItem;
    N2: TMenuItem;
    SYSTEM1: TMenuItem;
    SYSTEM2: TMenuItem;
    CancelButton: TButton;
    OwnerCheckBox: TCheckBox;
    DelButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure GetButtonClick(Sender: TObject);
    procedure SetOwnerButtonClick(Sender: TObject);
    procedure SetGrantButtonClick(Sender: TObject);
    procedure N1Click(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure SYSTEM1Click(Sender: TObject);
    procedure SYSTEM2Click(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure DelButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
   procedure GetPrinters(ServerName:String);
   procedure ButtonEnabled;
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  SWbemLocator:TSWbemLocator;
  ProcessFlag,BreakFlag:boolean;
  wnd,wnd1,wnd2,wnd3,wnd4,ok1,ok2:integer;
  w:DWORD;
const
 WaitPause=10000;
 WaitPause2=100;
 WaitCicl2=100;


implementation

{$R *.dfm}

procedure TMainForm.ButtonEnabled;
begin
 GetButton.Enabled:=not ProcessFlag;
 SetOwnerButton.Enabled:=not ProcessFlag;
 SetGrantButton.Enabled:=not ProcessFlag;
 DelButton.Enabled:=not ProcessFlag;
 CancelButton.Enabled:=ProcessFlag;
 N1.Enabled:=not ProcessFlag;
 N2.Enabled:=not ProcessFlag;
 SYSTEM1.Enabled:=not ProcessFlag;
 SYSTEM2.Enabled:=not ProcessFlag;
end;

procedure WaitWinExec(Path: PChar; uCmdShow: Word; msec: integer);
var { WaitWinExec }
 si : Tstartupinfo;
 p : Tprocessinformation;
begin
 FillChar( Si, SizeOf( Si ) , 0 );
 with Si do begin
  cb := SizeOf( Si);
  dwFlags := startf_UseShowWindow;
  wShowWindow := uCmdShow;
 end;
 Createprocess(nil,Path,nil,nil,false,Create_default_error_mode,nil,nil,si,p);
 Waitforsingleobject(p.hProcess,msec);
 TerminateProcess(p.hProcess,0);
 CloseHandle(p.hProcess);
end; { WaitWinExec }

procedure TMainForm.GetPrinters(ServerName:String);
var
 Service:             ISWbemServices;
 ObjectSet:           ISWbemObjectSet;
 SObject:             ISWbemObject;
 Enum:      IEnumVariant;
 Printers:             OleVariant;
 SD:             OleVariant;
 Value:               Cardinal;
 s: string;
 k,n:integer;
 f:integer;
begin
 if ProcessFlag then exit;
 if not Assigned(SWbemLocator) then exit;
 ProcessFlag:=true;
 ButtonEnabled;
 try
 CoInitialize(nil);
 Service:= SWbemLocator.ConnectServer(ServerName, 'root\CIMV2', '', '', '', '', 0, nil);
 MainProgressBar.Max:=100;
 MainProgressBar.Position:=1;
 SObject:= Service.Get('Win32_Printer', wbemFlagUseAmendedQualifiers, nil);
 ObjectSet:= SObject.Instances_(0, nil);
 Enum:= (ObjectSet._NewEnum) as IEnumVariant;
 MainProgressBar.Max:=ObjectSet.Count;
 if OwnerCheckBox.Checked then f:=1 else f:=0; k:=0;
 while (Enum.Next(1, Printers, Value) = S_OK) do
  begin
   inc(k);
   MainProgressBar.Position:=k;
   s:='';
   if f>0 then
    begin
     try
      Printers.GetSecurityDescriptor(SD);
      s:=SD.Owner.Name;
      f:=2;
     except
      if f=1 then f:=0;
     end;
    end;
   n:=MainForm.PrnCheckListBox.Items.Add(Printers.Name+' ~ '+s);
   PrnCheckListBox.Checked[n]:=s='SYSTEM';
   Application.ProcessMessages;
   if BreakFlag then break;
  end; { while }
 except
 end;
 MainProgressBar.Position:=0;
 SObject:=nil;
 ObjectSet:=nil;
 Enum:=nil;
 Printers:=Unassigned;
 SD:=Unassigned;
 SWbemLocator.Disconnect;
 Service:=nil;
 ProcessFlag:=false;
 ButtonEnabled;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
 try
  SWbemLocator:=TSWbemLocator.Create(Self);
 except
  SWbemLocator:=nil;
 end;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
 if Assigned(SWbemLocator) then SWbemLocator.Free;
end;

procedure TMainForm.GetButtonClick(Sender: TObject);
begin
 PrnCheckListBox.Clear;
 GetPrinters('.');
end;

function FindMainWindow(Handle: HWND; LPARAM: Longint):boolean; stdcall;
begin
 result:=true;
 if wnd=0 then wnd:=Handle;
end;

function FindAddWindow(Handle: HWND; LPARAM: Longint):boolean; stdcall;
var
  clss:array[0..254] of char;
  desc:array[0..254] of char;
  r:DWORD;
  s:string;
begin
  Result := True;
  SendMessageTimeout(Handle, WM_GETTEXT, 254, LongInt(@desc), SMTO_ABORTIFHUNG, WaitPause, r);
  GetClassName(Handle, clss, SizeOf(clss) - 1);
  s:=clss;
  if (Handle<>wnd) and (s='#32770') then wnd3:=Handle;
end;

function FindTabControl(Handle: HWND; l: lparam): Bool; stdcall;
var
  clss:array[0..254] of char;
  desc:array[0..254] of char;
  r:DWORD;
  s:string;
begin
  Result := True;
  SendMessageTimeout(Handle, WM_GETTEXT, 254, LongInt(@desc), SMTO_ABORTIFHUNG, WaitPause, r);
  GetClassName(Handle, clss, SizeOf(clss) - 1);
  s:=clss;
  if AnsiUppercase(s)='SYSTABCONTROL32' then wnd1:=Handle;
end;

function FindBtnAdvanced(Handle: HWND; l: lparam): Bool; stdcall;
var
  clss:array[0..254] of char;
  desc:array[0..254] of char;
  r:DWORD;
  s,s1:string;
begin
  Result := True;
  SendMessageTimeout(Handle, WM_GETTEXT, 254, LongInt(@desc), SMTO_ABORTIFHUNG, WaitPause, r);
  s1:=desc;
  GetClassName(Handle, clss, SizeOf(clss) - 1);
  s:=clss;
  if (AnsiUppercase(s)='BUTTON') then
   if (AnsiSameStr(StringReplace(s1,'&','',[]),'') or AnsiSameStr(StringReplace(s1,'&','',[]),'Advanced')) then
    wnd2:=Handle
   else
   if AnsiSameStr(StringReplace(s1,'&','',[]),'OK') or AnsiSameStr(StringReplace(s1,'&','',[]),'') then
    ok1:=Handle;
end;

function FindListView(Handle: HWND; l: lparam): Bool; stdcall;
var
  clss:array[0..254] of char;
  desc:array[0..254] of char;
  r:DWORD;
  s,s1:string;
begin
  Result := True;
  SendMessageTimeout(Handle, WM_GETTEXT, 254, LongInt(@desc), SMTO_ABORTIFHUNG, WaitPause, r);
  GetClassName(Handle, clss, SizeOf(clss) - 1);
  s:=clss;
  s1:=desc;
  if AnsiUppercase(s)='SYSLISTVIEW32' then if wnd4=0 then wnd4:=Handle;
  if AnsiUppercase(s)='BUTTON' then
   if AnsiSameStr(StringReplace(s1,'&','',[]),'OK') or AnsiSameStr(StringReplace(s1,'&','',[]),'') then
    ok2:=Handle;
end;

procedure SleepM;
begin
 Sleep(WaitPause2);
 Application.ProcessMessages;
end;

procedure TMainForm.SetOwnerButtonClick(Sender: TObject);
var
 i,j:integer;
 s:string;
 si:TStartupInfo;
 p:TProcessInformation;
 tc:TTCItemHeader;
 ptxt:PChar;
 ptc:PTCItemHeader;
 w,w1:DWORD;
 ti,i1:integer;
 atxt:array[0..255] of char;
 n:integer;
 a,c:string;
begin
 if ProcessFlag then exit;
 ProcessFlag:=true;
 ButtonEnabled;
 BreakFlag:=false;
 n:=PrnCheckListBox.Count;
 i:=0;
 MainProgressBar.Max:=n;
 while i<n do
  begin
   MainProgressBar.Position:=i+1;
   if PrnCheckListBox.Checked[i] then
    begin
     s:=PrnCheckListBox.Items[i];
     s:=Copy(s,1,Pos(' ~ ',s)-1);
     fillchar(si,SizeOf(si),0);
     with Si do
      begin
       cb:=SizeOf(Si);
       dwFlags:=STARTF_USESHOWWINDOW or STARTF_FORCEONFEEDBACK;
       wShowWindow:=SW_SHOWNORMAL;
      end;
     wnd:=0;
     a:='c:\windows\system32\rundll32.exe';
     c:=' printui.dll,PrintUIEntry /p /n "'+s+'"';
     CreateProcess(PChar(a),PChar(c),nil,nil,false,CREATE_DEFAULT_ERROR_MODE,nil,nil,si,p);
     WaitForInputIdle(p.hProcess,WaitPause);
     EnumThreadWindows(p.dwThreadId, @FindMainWindow, 0);
     if wnd>0 then
      begin
       wnd1:=0;
       EnumChildWindows(wnd,@FindTabControl,0);
       if wnd1>0 then
        begin
         SendMessageTimeOut(wnd1, TCM_GETITEMCOUNT, 0, 0, SMTO_ABORTIFHUNG, WaitPause, w);
         fillchar(tc,SizeOf(tc),0);
         ptc:=VirtualAllocEx(p.hProcess,nil,SizeOf(tc),MEM_COMMIT,PAGE_READWRITE);
         ptxt:=VirtualAllocEx(p.hProcess,nil,255,MEM_COMMIT,PAGE_READWRITE);
         tc.mask:=TCIF_TEXT;
         tc.cchTextMax:=255;
         tc.pszText:=ptxt;
         WriteProcessMemory(p.hProcess, ptc, @tc, SizeOf(tc), w1);
         ti:=-1;
         for i1:=0 to w-1 do
          if SendMessageTimeOut(wnd1, TCM_GETITEM, i1, LongWord(ptc), SMTO_ABORTIFHUNG, WaitPause, w1)<>0 then
           begin
            ReadProcessMemory(p.hProcess, tc.pszText, @atxt[0], 255, w1);
            s:=atxt;
            if AnsiSameStr(StringReplace(s,'&','',[]),'') or
             AnsiSameStr(StringReplace(s,'&','',[]),'Security') then begin ti:=i1; break; end;
           end;
         VirtualFreeEx(p.hProcess,ptxt,0,MEM_RELEASE);
         VirtualFreeEx(p.hProcess,ptc,0,MEM_RELEASE);
         if ti>=0 then
          begin
           SendMessageTimeOut(wnd1, TCM_SETCURFOCUS, ti, 0, SMTO_ABORTIFHUNG, WaitPause, w);
           ok1:=0;
           wnd2:=0;
           for j:=1 to WaitCicl2 do
            begin
             SleepM;
             if BreakFlag then break;
             EnumChildWindows(wnd,@FindBtnAdvanced,0);
             if wnd2>0 then break;
            end;
           if BreakFlag then break;
           if wnd2>0 then
            begin
             PostMessage(wnd2, BM_CLICK, 0, 0);
             wnd3:=0;
             for j:=1 to WaitCicl2 do
              begin
               SleepM;
               if BreakFlag then break;
               EnumThreadWindows(p.dwThreadId, @FindAddWindow, 0);
               if wnd3>0 then break;
              end;
             if BreakFlag then break;
             if wnd3>0 then
              begin
               wnd1:=0;
               for j:=1 to WaitCicl2 do
                begin
                 SleepM;
                 if BreakFlag then break;
                 EnumChildWindows(wnd3,@FindTabControl,0);
                 if wnd1>0 then break;
                end;
               if BreakFlag then break;
               if wnd1>0 then
                begin
                 SendMessageTimeOut(wnd1, TCM_GETITEMCOUNT, 0, 0, SMTO_ABORTIFHUNG, WaitPause, w);
                 fillchar(tc,SizeOf(tc),0);
                 ptc:=VirtualAllocEx(p.hProcess,nil,SizeOf(tc),MEM_COMMIT,PAGE_READWRITE);
                 ptxt:=VirtualAllocEx(p.hProcess,nil,255,MEM_COMMIT,PAGE_READWRITE);
                 tc.mask:=TCIF_TEXT;
                 tc.cchTextMax:=255;
                 tc.pszText:=ptxt;
                 WriteProcessMemory(p.hProcess, ptc, @tc, SizeOf(tc), w1);
                 ti:=-1;
                 for i1:=0 to w-1 do
                  if SendMessageTimeOut(wnd1, TCM_GETITEM, i1, LongWord(ptc), SMTO_ABORTIFHUNG, WaitPause, w1)<>0 then
                   begin
                    ReadProcessMemory(p.hProcess, tc.pszText, @atxt[0], 255, w1);
                    s:=atxt;
                    if AnsiSameStr(StringReplace(s,'&','',[]),'') or
                     AnsiSameStr(StringReplace(s,'&','',[]),'Owner') then begin ti:=i1; break; end;
                   end;
                 VirtualFreeEx(p.hProcess,ptxt,0,MEM_RELEASE);
                 VirtualFreeEx(p.hProcess,ptc,0,MEM_RELEASE);
                 if ti>=0 then
                  begin
                   SendMessageTimeOut(wnd1, TCM_SETCURFOCUS, ti, 0, SMTO_ABORTIFHUNG, WaitPause, w);
                   wnd4:=0;
                   ok2:=0;
                   for j:=1 to WaitCicl2 do
                    begin
                     SleepM;
                     if BreakFlag then break;
                     EnumChildWindows(wnd3,@FindListView,0);
                     if wnd4>0 then break;
                   end;
                   if BreakFlag then break;
                   if wnd4>0 then
                    begin
                     PostMessage(wnd4, WM_LBUTTONDOWN, 0, MAKELPARAM(10, 20));
                     PostMessage(wnd4, WM_LBUTTONUP, 0, MAKELPARAM(10, 20));
                     Sleep(WaitPause2);
                     SendMessage(ok2, BM_CLICK, 0, 0);
                     for j:=1 to WaitCicl2 do
                      begin
                       if not IsWindow(wnd3) then break;
                       SleepM;
                       if BreakFlag then break;
                      end;
                     if BreakFlag then break;
                     SendMessage(ok1, BM_CLICK, 0, 0);
                     for j:=1 to WaitCicl2 do
                      begin
                       if not IsWindow(wnd1) then break;
                       SleepM;
                       if BreakFlag then break;
                      end;
                    end;
                  end;
                end;
              end;
            end;
          end;
        end;
      end;
     TerminateProcess(p.hProcess,0);
     CloseHandle(p.hProcess);
    end;
   i:=i+1;
   Application.ProcessMessages;
   if BreakFlag then break;
  end;
 MainProgressBar.Position:=0;
 ProcessFlag:=false;
 ButtonEnabled;
end;

procedure TMainForm.SetGrantButtonClick(Sender: TObject);
var
 s,o,p:string;
 i,n:integer;
begin
 if ProcessFlag then exit;
 p:=ExtractFilePath(Paramstr(0))+'subinacl.exe';
 if not FileExists(p) then
  begin
   ShowMessage('   '+p);
   exit;
  end;
 ProcessFlag:=true;
 ButtonEnabled;
 BreakFlag:=false;
 n:=PrnCheckListBox.Count;
 MainProgressBar.Max:=n;
 i:=0;
 while i<n do
  begin
   MainProgressBar.Position:=i+1;
   if PrnCheckListBox.Checked[i] then
    begin
     s:=PrnCheckListBox.Items[i];
     s:=Copy(s,1,Pos(' ~ ',s)-1);
     o:=p+' /printer "'+s+'" /grant="Print Operators"=F';
     WaitWinExec(PChar(o),SW_HIDE,WaitPause);
    end;
   i:=i+1;
   Application.Processmessages;
   if BreakFlag then break;
  end;
 MainProgressBar.Position:=0;
 ProcessFlag:=false;
 ButtonEnabled;
end;

procedure TMainForm.N1Click(Sender: TObject);
var
 i,n:integer;
begin
 if ProcessFlag then exit;
 ProcessFlag:=true;
 ButtonEnabled;
 n:=PrnCheckListBox.Count;
 MainProgressBar.Max:=n;
 i:=0;
 while i<n do
  begin
   MainProgressBar.Position:=i+1;
   PrnCheckListBox.Checked[i]:=true;
   Application.ProcessMessages;
   if BreakFlag then break;
   i:=i+1;
  end;
 MainProgressBar.Position:=0;
 ProcessFlag:=false;
 ButtonEnabled;
end;

procedure TMainForm.N2Click(Sender: TObject);
var
 i,n:integer;
begin
 if ProcessFlag then exit;
 ProcessFlag:=true;
 ButtonEnabled;
 n:=PrnCheckListBox.Count;
 MainProgressBar.Max:=n;
 i:=0;
 while i<n do
  begin
   MainProgressBar.Position:=i+1;
   PrnCheckListBox.Checked[i]:=false;
   Application.ProcessMessages;
   if BreakFlag then break;
   i:=i+1;
  end;
 MainProgressBar.Position:=0;
 ProcessFlag:=false;
 ButtonEnabled;
end;

procedure TMainForm.SYSTEM1Click(Sender: TObject);
var
 i,n,j:integer;
 s:string;
begin
 if ProcessFlag then exit;
 ProcessFlag:=true;
 ButtonEnabled;
 n:=PrnCheckListBox.Count;
 MainProgressBar.Max:=n;
 i:=0;
 while i<n do
  begin
   MainProgressBar.Position:=i+1;
   s:=PrnCheckListBox.Items[i];
   j:=Pos(' ~ ',s);
   s:=Copy(s,j+3,length(s)-j-3+1);
   PrnCheckListBox.Checked[i]:=s='SYSTEM';
   Application.ProcessMessages;
   if BreakFlag then break;
   i:=i+1;
  end;
 MainProgressBar.Position:=0;
 ProcessFlag:=false;
 ButtonEnabled;
end;

procedure TMainForm.SYSTEM2Click(Sender: TObject);
var
 i,n,j:integer;
 s:string;
begin
 if ProcessFlag then exit;
 ProcessFlag:=true;
 ButtonEnabled;
 n:=PrnCheckListBox.Count;
 MainProgressBar.Max:=n;
 i:=0;
 while i<n do
  begin
   MainProgressBar.Position:=i+1;
   s:=PrnCheckListBox.Items[i];
   j:=Pos(' ~ ',s);
   s:=Copy(s,j+3,length(s)-j-3+1);
   PrnCheckListBox.Checked[i]:=s<>'SYSTEM';
   Application.ProcessMessages;
   if BreakFlag then break;
   i:=i+1;
  end;
 MainProgressBar.Position:=0;
 ProcessFlag:=false;
 ButtonEnabled;
end;

procedure TMainForm.CancelButtonClick(Sender: TObject);
begin
 BreakFlag:=true;
end;

procedure TMainForm.DelButtonClick(Sender: TObject);
var
 s,o:string;
 i,n:integer;
begin
 if ProcessFlag then exit;
 ProcessFlag:=true;
 ButtonEnabled;
 BreakFlag:=false;
 n:=PrnCheckListBox.Count;
 MainProgressBar.Max:=n;
 i:=0;
 while i<n do
  begin
   MainProgressBar.Position:=i+1;
   if PrnCheckListBox.Checked[i] then
    begin
     s:=PrnCheckListBox.Items[i];
     s:=Copy(s,1,Pos(' ~ ',s)-1);
     o:='c:\windows\system32\rundll32.exe printui.dll,PrintUIEntry /dl /n "'+s+'"';
     WaitWinExec(PChar(o),SW_SHOWNORMAL,WaitPause);
    end;
   i:=i+1;
   Application.Processmessages;
   if BreakFlag then break;
  end;
 MainProgressBar.Position:=0;
 ProcessFlag:=false;
 ButtonEnabled;
end;

end.


