unit renunit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, filectrl,
  StdCtrls, Grids,inifiles;

type
  TRenamerForm = class(TForm)
    PathDirLabel: TLabel;
    PathDirEdit: TEdit;
    InputFileMaskLabel: TLabel;
    InputFileMaskEdit: TEdit;
    OutputFileMaskEdit: TEdit;
    OutputFileMaskLabel: TLabel;
    TestButton: TButton;
    MainStringGrid: TStringGrid;
    RenButton: TButton;
    MainMemo: TMemo;
    procedure PathDirEditDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TestButtonClick(Sender: TObject);
    procedure PathDirEditChange(Sender: TObject);
    procedure RenButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  RenamerForm: TRenamerForm;
  PathDir:string;
  InputMask:string;
  OutputMask:string;
  OutputCounter:integer;
  IniFile:TIniFile;

implementation

{$R *.DFM}

procedure TRenamerForm.PathDirEditDblClick(Sender: TObject);
const
 SELDIRHELP=1000;
begin
 PathDir := PathDirEdit.Text;
 if SelectDirectory(PathDir, [sdAllowCreate, sdPerformCreate, sdPrompt],SELDIRHELP) then
  PathDirEdit.Text:=PathDir;
end;

procedure TRenamerForm.FormCreate(Sender: TObject);
begin
 IniFile:=TIniFile.Create('renamer.ini');
 try
  PathDirEdit.Text:=IniFile.ReadString('Main','Path','C:\');
  InputFileMaskEdit.Text:=IniFile.ReadString('Main','InputMask','*.*');
  OutputFileMaskEdit.Text:=IniFile.ReadString('Main','OutputMask','p$$$.jpg');
 finally
  IniFile.Free;
 end;
 PathDir := PathDirEdit.Text;
 OutputCounter:=0;
end;

function GetFileList(const Path: string): TStringList;
var
  I: Integer;
  SearchRec: TSearchRec;
begin
  Result := TStringList.Create;
  try
    I := FindFirst(Path, 0, SearchRec);
    while I = 0 do
    begin
      Result.Add(SearchRec.Name);
      I := FindNext(SearchRec);
    end;
    Result.Sorted:=true;
  except
    Result.Free;
    raise;
  end;
end;

procedure TRenamerForm.TestButtonClick(Sender: TObject);
var
 mask:string;
 mask1:string;
 rs:string;
 i,j:integer;
 c,count:integer;
 ss:TStringList;
procedure cnt;
var
 s:string;
 h:integer;
begin
 if c>0 then
  begin
   Str(OutputCounter:c,s);
   for h:=1 to length(s) do
    if s[h]=' ' then s[h]:='0';
   c:=0;
   rs:=s+rs;
  end;
end;
begin
 InputMask:=InputFileMaskEdit.Text;
 OutputMask:=OutputFileMaskEdit.Text;
 mask1:=OutputMask;
 mask:=Trim(PathDir);
 if length(mask)=3 then
  mask:=mask+InputMask
 else
  mask:=mask+'\'+InputMask;
 MainStringGrid.Cols[0].Clear;
 MainStringGrid.Cols[1].Clear;
 ss:=GetFileList(mask);
 count:=ss.Count;
 MainStringGrid.RowCount:=count;
 if count=0 then
  begin
   ss.Free;
   Exit;
  end;
 MainStringGrid.Cols[0].AddStrings(ss);
 ss.Free;
 OutputCounter:=0;
 for i:=0 to count-1 do
  begin
   rs:=''; c:=0;
   for j:=length(mask1) downto 1 do
    begin
     case mask1[j] of
      '?':begin
           cnt;
           if j<=length(MainStringGrid.Cols[0].Strings[i]) then
            rs:=MainStringGrid.Cols[0].Strings[i][j]+rs;
          end;
      '#': cnt;
      '$':begin
           if c=0 then inc(OutputCounter);
           inc(c);
           if j=1 then cnt;
          end;
      else
       begin
        cnt;
        rs:=mask1[j]+rs;
       end;
     end;
    end;
   MainStringGrid.Cols[1].Add(rs);
  end;
end;

procedure TRenamerForm.PathDirEditChange(Sender: TObject);
begin
 PathDir := PathDirEdit.Text;
end;

procedure TRenamerForm.RenButtonClick(Sender: TObject);
const
 mydir='$$TEMP$$';
var
 i:integer;
 dir,olddir,s,s1:string;
begin
 MainMemo.Lines.Clear;
 MainMemo.Lines.Add(':');
 dir:=Trim(PathDir);
 if length(dir)=3 then
  begin
   olddir:=dir;
   dir:=dir+MyDir
  end
 else
  begin
   olddir:=dir+'\';
   dir:=dir+'\'+MyDir;
  end;
 CreateDir(dir);
 for i:=0 to MainStringGrid.RowCount-1 do
  begin
   s:=MainStringGrid.Cells[0,i];
   s1:=MainStringGrid.Cells[1,i];
   if s<>'' then
     if FileExists(olddir+s) then
      if not RenameFile(olddir+s,dir+'\'+s1) then
       MainMemo.Lines.Add(' '+olddir+s+'  ')
      else
     else
      MainMemo.Lines.Add(' '+olddir+s+'  ');
  end;
 for i:=0 to MainStringGrid.RowCount-1 do
  begin
   s:=MainStringGrid.Cells[1,i];
   if s<>'' then
    if FileExists(dir+'\'+s) then
     if FileExists(olddir+s) then
      MainMemo.Lines.Add(' '+olddir+s+'  ')
     else
     if not RenameFile(dir+'\'+s,olddir+s) then
      MainMemo.Lines.Add(' '+dir+'\'+s+'  ')
      else
     else
      MainMemo.Lines.Add(' '+dir+'\'+s+'  ');
  end;
 RemoveDir(dir);
end;

procedure TRenamerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 IniFile:=TIniFile.Create('renamer.ini');
 try
  IniFile.WriteString('Main','Path',PathDir);
  IniFile.WriteString('Main','InputMask',InputFileMaskEdit.Text);
  IniFile.WriteString('Main','OutputMask',OutputFileMaskEdit.Text);
 finally
  IniFile.Free;
 end;
end;

end.
